/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.option;

import com.aspectran.shell.command.option.OptionUtils;
import com.aspectran.shell.command.option.OptionValueType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Option
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -7707766888283034409L;
    public static final int UNINITIALIZED = -1;
    public static final int UNLIMITED_VALUES = -2;
    private final String name;
    private String longName;
    private String valueName;
    private boolean withEqualSign;
    private String description;
    private boolean required;
    private boolean optionalValue;
    private int numberOfValues = -1;
    private OptionValueType valueType = OptionValueType.STRING;
    private List<String> values = new ArrayList<String>();

    private Option(Builder builder) {
        this.name = builder.name;
        this.longName = builder.longName;
        this.valueName = builder.valueName;
        this.valueType = builder.valueType;
        this.withEqualSign = builder.withEqualSign;
        this.numberOfValues = builder.numberOfValues;
        this.optionalValue = builder.optionalValue;
        this.required = builder.required;
        this.description = builder.description;
    }

    public Option(String name, String description) throws IllegalArgumentException {
        this(name, null, false, description);
    }

    public Option(String name, boolean hasValue, String description) throws IllegalArgumentException {
        this(name, null, hasValue, description);
    }

    public Option(String name, String longName, boolean hasValue, String description) throws IllegalArgumentException {
        OptionUtils.validateOption(name);
        this.name = name;
        this.longName = longName;
        if (hasValue) {
            this.numberOfValues = 1;
        }
        this.description = description;
    }

    public int getId() {
        return this.getKey().charAt(0);
    }

    public String getKey() {
        return this.name == null ? this.longName : this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getLongName() {
        return this.longName;
    }

    public void setLongName(String longName) {
        this.longName = longName;
    }

    public boolean hasLongName() {
        return this.longName != null;
    }

    public String getValueName() {
        return this.valueName;
    }

    public void setValueName(String valueName) {
        this.valueName = valueName;
    }

    public boolean hasValueName() {
        return this.valueName != null && this.valueName.length() > 0;
    }

    public OptionValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(OptionValueType valueType) {
        this.valueType = valueType;
    }

    public void setOptionalValue(boolean optionalValue) {
        this.optionalValue = optionalValue;
    }

    public boolean hasOptionalValue() {
        return this.optionalValue;
    }

    public int getNumberOfValues() {
        return this.numberOfValues;
    }

    public void setNumberOfValues(int num) {
        this.numberOfValues = num;
    }

    public boolean hasValue() {
        return this.numberOfValues > 0 || this.numberOfValues == -2;
    }

    public boolean hasValues() {
        return this.numberOfValues > 1 || this.numberOfValues == -2;
    }

    public void withEqualSign() {
        this.setWithEqualSign(true);
    }

    public boolean isWithEqualSign() {
        return this.withEqualSign;
    }

    public void setWithEqualSign(boolean withEqualSign) {
        this.withEqualSign = withEqualSign;
    }

    public void addValue(String value) {
        if (this.numberOfValues == -1) {
            throw new RuntimeException("NO_ARGS_ALLOWED");
        }
        this.add(value);
    }

    private void add(String value) {
        if (!this.acceptsValue()) {
            throw new RuntimeException("Cannot add value, list full");
        }
        this.values.add(value);
    }

    public String getValue() {
        return this.hasNoValues() ? null : this.values.get(0);
    }

    public String getValue(int index) throws IndexOutOfBoundsException {
        return this.hasNoValues() ? null : this.values.get(index);
    }

    public String getValue(String defaultValue) {
        String value = this.getValue();
        return value != null ? value : defaultValue;
    }

    public String[] getValues() {
        return this.hasNoValues() ? null : this.values.toArray(new String[0]);
    }

    public List<String> getValuesList() {
        return this.values;
    }

    private boolean hasNoValues() {
        return this.values.isEmpty();
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Option option = (Option)o;
        if (!Objects.equals(this.name, option.name)) {
            return false;
        }
        return Objects.equals(this.longName, option.longName);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.longName != null ? this.longName.hashCode() : 0);
        return result;
    }

    public Option clone() {
        try {
            Option option = (Option)super.clone();
            option.values = new ArrayList<String>(this.values);
            return option;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("A CloneNotSupportedException was thrown: " + e.getMessage());
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append("[ option: ");
        buf.append(this.name);
        if (this.longName != null) {
            buf.append(" ").append(this.longName);
        }
        buf.append(" ");
        if (this.hasValues()) {
            buf.append("[ARG...]");
        } else if (this.hasValue()) {
            buf.append(" [ARG]");
        }
        buf.append(" :: ").append(this.description);
        if (this.valueType != null) {
            buf.append(" :: ").append((Object)this.valueType);
        }
        buf.append(" ]");
        return buf.toString();
    }

    void clearValues() {
        this.values.clear();
    }

    boolean acceptsValue() {
        return this.hasValue() && (this.numberOfValues <= 0 || this.values.size() < this.numberOfValues);
    }

    boolean requiresValue() {
        if (this.optionalValue) {
            return false;
        }
        if (this.numberOfValues == -2) {
            return this.values.isEmpty();
        }
        return this.acceptsValue();
    }

    public static Builder builder() {
        return Option.builder(null);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public static final class Builder {
        private final String name;
        private String longName;
        private String description;
        private String valueName;
        private boolean withEqualSign;
        private boolean required;
        private boolean optionalValue;
        private int numberOfValues = -1;
        private OptionValueType valueType = OptionValueType.STRING;

        private Builder(String name) throws IllegalArgumentException {
            OptionUtils.validateOption(name);
            this.name = name;
        }

        public Builder longName(String longName) {
            this.longName = longName;
            return this;
        }

        public Builder valueName(String valueName) {
            this.valueName = valueName;
            return this;
        }

        public Builder valueType(OptionValueType valueType) {
            this.valueType = valueType;
            return this;
        }

        public Builder withEqualSign() {
            this.withEqualSign = true;
            return this.hasValue();
        }

        public Builder hasValue() {
            return this.hasValue(true);
        }

        public Builder hasValue(boolean hasValue) {
            this.numberOfValues = hasValue ? 1 : -1;
            return this;
        }

        public Builder hasValues() {
            this.numberOfValues = -2;
            return this;
        }

        public Builder numberOfValues(int numberOfValues) {
            this.numberOfValues = numberOfValues;
            return this;
        }

        public Builder optionalValue() {
            this.optionalValue = true;
            return this;
        }

        public Builder required() {
            return this.required(true);
        }

        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        public Builder desc(String description) {
            this.description = description;
            return this;
        }

        public Option build() {
            if (this.name == null && this.longName == null) {
                throw new IllegalArgumentException("Either name or longName must be specified");
            }
            return new Option(this);
        }
    }
}

