/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.command.option;

import com.aspectran.core.util.StringUtils;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.OptionParserException;
import com.aspectran.shell.command.option.OptionUtils;
import com.aspectran.shell.command.option.OptionValueType;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class ParsedOptions
implements Serializable {
    private static final long serialVersionUID = -875791688751934582L;
    private final List<Option> options = new ArrayList<Option>();
    private final List<String> args = new LinkedList<String>();

    protected ParsedOptions() {
    }

    public boolean hasOption(Option opt) {
        return this.options.contains(opt);
    }

    public boolean hasOption(String name) {
        return this.hasOption(this.resolveOption(name));
    }

    public boolean hasOption(char name) {
        return this.hasOption(String.valueOf(name));
    }

    public boolean hasOptions() {
        return !this.options.isEmpty();
    }

    public <T> T getTypedValue(Option option) throws OptionParserException {
        if (option == null) {
            return null;
        }
        String value = this.getValue(option);
        if (value == null) {
            return null;
        }
        OptionValueType valueType = option.getValueType();
        if (valueType == OptionValueType.STRING) {
            return (T)value;
        }
        if (valueType == OptionValueType.INT) {
            try {
                return (T)Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new OptionParserException(e.getMessage());
            }
        }
        if (valueType == OptionValueType.LONG) {
            try {
                return (T)Long.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new OptionParserException(e.getMessage());
            }
        }
        if (valueType == OptionValueType.FLOAT) {
            try {
                return (T)Float.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new OptionParserException(e.getMessage());
            }
        }
        if (valueType == OptionValueType.DOUBLE) {
            try {
                return (T)Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new OptionParserException(e.getMessage());
            }
        }
        if (valueType == OptionValueType.BOOLEAN) {
            try {
                return (T)Boolean.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new OptionParserException(e.getMessage());
            }
        }
        if (valueType == OptionValueType.FILE) {
            return (T)new File(value);
        }
        return null;
    }

    public <T> T getTypedValue(String name) throws OptionParserException {
        return this.getTypedValue(this.resolveOption(name));
    }

    public <T> T getTypedValue(char name) throws OptionParserException {
        return this.getTypedValue(String.valueOf(name));
    }

    public String getValue(Option option) {
        if (option == null) {
            return null;
        }
        String[] values = this.getValues(option);
        return values == null ? null : values[0];
    }

    public String getValue(String name) {
        return this.getValue(this.resolveOption(name));
    }

    public String getValue(char name) {
        return this.getValue(String.valueOf(name));
    }

    public String[] getValues(Option option) {
        ArrayList<String> values = new ArrayList<String>();
        for (Option processedOption : this.options) {
            if (!processedOption.equals(option)) continue;
            values.addAll(processedOption.getValuesList());
        }
        return values.isEmpty() ? null : values.toArray(new String[0]);
    }

    public String[] getValues(String name) {
        return this.getValues(this.resolveOption(name));
    }

    public String[] getValues(char opt) {
        return this.getValues(String.valueOf(opt));
    }

    public String getValue(Option option, String defaultValue) {
        String answer = this.getValue(option);
        return answer != null ? answer : defaultValue;
    }

    public String getValue(String name, String defaultValue) {
        return this.getValue(this.resolveOption(name), defaultValue);
    }

    public String getValue(char name, String defaultValue) {
        return this.getValue(String.valueOf(name), defaultValue);
    }

    private Option resolveOption(String name) {
        name = OptionUtils.stripLeadingHyphens(name);
        for (Option option : this.options) {
            if (name.equals(option.getName())) {
                return option;
            }
            if (!name.equals(option.getLongName())) continue;
            return option;
        }
        return null;
    }

    public Properties getProperties(Option option) {
        Properties props = new Properties();
        for (Option processedOption : this.options) {
            if (!processedOption.equals(option)) continue;
            List<String> values = processedOption.getValuesList();
            if (values.size() >= 2) {
                props.put(values.get(0), values.get(1));
                continue;
            }
            if (values.size() != 1) continue;
            props.put(values.get(0), "true");
        }
        return props;
    }

    public Properties getProperties(String name) {
        Properties props = new Properties();
        for (Option option : this.options) {
            if (!name.equals(option.getName()) && !name.equals(option.getLongName())) continue;
            List<String> values = option.getValuesList();
            if (values.size() >= 2) {
                props.put(values.get(0), values.get(1));
                continue;
            }
            if (values.size() != 1) continue;
            props.put(values.get(0), "true");
        }
        return props;
    }

    protected void addOption(Option opt) {
        this.options.add(opt);
    }

    public Iterator<Option> iterator() {
        return this.options.iterator();
    }

    public Option[] getOptions() {
        return this.options.toArray(new Option[0]);
    }

    public boolean hasArgs() {
        return !this.args.isEmpty();
    }

    public String[] getArgs() {
        return this.args.toArray(new String[0]);
    }

    public String getFirstArg() {
        return !this.args.isEmpty() ? this.args.get(0) : null;
    }

    public List<String> getArgList() {
        return this.args;
    }

    protected void addArg(String arg) {
        if (StringUtils.hasLength((String)arg)) {
            this.args.add(arg);
        }
    }
}

