/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.console;

import com.aspectran.shell.command.CommandInterpreter;
import com.aspectran.shell.console.Console;
import java.io.File;
import java.nio.charset.Charset;

public abstract class AbstractConsole
implements Console {
    private String commandPrompt = "Aspectran> ";
    private final String encoding;
    private File workingDir;
    private CommandInterpreter interpreter;

    public AbstractConsole(String encoding) {
        this.encoding = encoding != null ? encoding : Charset.defaultCharset().name();
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public String getCommandPrompt() {
        return this.commandPrompt;
    }

    @Override
    public void setCommandPrompt(String commandPrompt) {
        this.commandPrompt = commandPrompt;
    }

    @Override
    public File getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    @Override
    public CommandInterpreter getInterpreter() {
        return this.interpreter;
    }

    @Override
    public void setInterpreter(CommandInterpreter interpreter) {
        this.interpreter = interpreter;
    }

    protected String readMultiCommandLine(String line) {
        String quote;
        if ("//".equals(line)) {
            String next = this.readRawCommandLine("// ");
            if (next.isEmpty()) {
                return next;
            }
            this.readMultiCommandLine("//");
        }
        if ((quote = this.searchQuote(line)) != null || line.endsWith("\\")) {
            String next = this.readRawCommandLine("> ").trim();
            line = next.startsWith("//") ? this.readMultiCommandLine(line) : (quote != null ? line + System.lineSeparator() + next : line.substring(0, line.length() - "\\".length()).trim() + " " + next);
        }
        if ((quote = this.searchQuote(line)) != null) {
            return this.readMultiCommandLine(line);
        }
        if (line.endsWith("\\")) {
            line = this.readMultiCommandLine(line);
        }
        return line;
    }

    protected String readMultiLine(String line) {
        if (line == null) {
            line = this.readRawLine("> ");
        }
        if (line.endsWith("\\")) {
            line = line.substring(0, line.length() - "\\".length()) + System.lineSeparator() + this.readMultiLine(null);
        }
        return line;
    }

    protected abstract String readRawCommandLine(String var1);

    protected abstract String readRawLine(String var1);

    private String searchQuote(String line) {
        boolean doubleQuote = false;
        boolean singleQuote = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\"' && !singleQuote) {
                doubleQuote = !doubleQuote;
                continue;
            }
            if (c != '\'' || doubleQuote) continue;
            singleQuote = !singleQuote;
        }
        if (doubleQuote) {
            return "\"";
        }
        if (singleQuote) {
            return "'";
        }
        return null;
    }
}

