/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.console;

import com.aspectran.shell.console.AbstractConsole;
import java.io.BufferedReader;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;

public class DefaultConsole
extends AbstractConsole {
    private volatile boolean busy;

    public DefaultConsole() {
        this(null);
    }

    public DefaultConsole(String encoding) {
        super(encoding);
    }

    @Override
    public String readCommandLine() {
        String prompt = this.getCommandPrompt();
        return this.readCommandLine(prompt);
    }

    @Override
    public String readCommandLine(String prompt) {
        return this.readMultiCommandLine(this.readRawLine(prompt).trim());
    }

    @Override
    public String readLine() {
        return this.readLine(null);
    }

    @Override
    public String readLine(String prompt) {
        try {
            this.busy = true;
            String string = this.readMultiLine(this.readRawLine(prompt));
            return string;
        }
        finally {
            this.busy = false;
        }
    }

    @Override
    public String readLine(String format, Object ... args) {
        return this.readLine(String.format(format, args));
    }

    @Override
    public String readPassword() {
        return this.readPassword(null);
    }

    @Override
    public String readPassword(String prompt) {
        if (System.console() != null) {
            return new String(System.console().readPassword(prompt, new Object[0]));
        }
        return this.readLine(prompt);
    }

    @Override
    public String readPassword(String format, Object ... args) {
        return this.readPassword(String.format(format, args));
    }

    @Override
    protected String readRawCommandLine(String prompt) {
        return this.readRawLine(prompt);
    }

    @Override
    protected String readRawLine(String prompt) {
        try {
            String line;
            if (System.console() != null) {
                line = System.console().readLine(prompt, new Object[0]);
            } else {
                if (prompt != null) {
                    this.write(prompt);
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
                line = reader.readLine();
            }
            return line;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public void write(String string) {
        System.out.print(string);
    }

    @Override
    public void write(String format, Object ... args) {
        System.out.print(String.format(format, args));
    }

    @Override
    public void writeLine(String string) {
        System.out.println(string);
    }

    @Override
    public void writeLine(String format, Object ... args) {
        System.out.println(String.format(format, args));
    }

    @Override
    public void writeLine() {
        System.out.println();
    }

    @Override
    public void writeError(String string) {
        System.err.println(string);
    }

    @Override
    public void writeError(String format, Object ... args) {
        System.err.println(String.format(format, args));
    }

    @Override
    public void clearScreen() {
        System.out.print("\u001b[H\u001b[2J");
        System.out.flush();
    }

    @Override
    public String getEncoding() {
        return Charset.defaultCharset().name();
    }

    @Override
    public OutputStream getOutput() {
        return System.out;
    }

    @Override
    public PrintWriter getWriter() {
        if (System.console() != null) {
            return System.console().writer();
        }
        return new PrintWriter(System.out);
    }

    @Override
    public String[] getStyles() {
        return null;
    }

    @Override
    public void setStyle(String ... styles) {
    }

    @Override
    public void styleOff() {
    }

    @Override
    public boolean isBusy() {
        return this.busy;
    }

    @Override
    public boolean confirmRestart() {
        return this.confirmRestart(null);
    }

    @Override
    public boolean confirmRestart(String message) {
        String confirm;
        String yn;
        if (this.isBusy()) {
            this.writeLine("Illegal State");
            return false;
        }
        if (message != null) {
            this.writeLine(message);
        }
        return (yn = this.readLine(confirm = "Would you like to restart this shell [Y/n]? ")).isEmpty() || yn.equalsIgnoreCase("Y");
    }

    @Override
    public boolean confirmQuit() {
        String confirm = "Are you sure you want to quit [Y/n]? ";
        String yn = this.readLine(confirm);
        return yn.isEmpty() || yn.equalsIgnoreCase("Y");
    }

    @Override
    public List<String> getCommandHistory() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void clearCommandHistory() {
    }

    @Override
    public void setCommandHistoryFile(String historyFile) {
    }
}

