/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.service;

import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.adapter.SessionAdapter;
import com.aspectran.core.component.session.DefaultSessionManager;
import com.aspectran.core.component.session.SessionAgent;
import com.aspectran.core.component.session.SessionManager;
import com.aspectran.core.context.config.SessionConfig;
import com.aspectran.core.context.expr.TokenExpression;
import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.expr.token.TokenParser;
import com.aspectran.core.service.AspectranCoreService;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.shell.adapter.ShellApplicationAdapter;
import com.aspectran.shell.adapter.ShellSessionAdapter;
import com.aspectran.shell.console.Console;
import com.aspectran.shell.service.ShellService;

public abstract class AbstractShellService
extends AspectranCoreService
implements ShellService {
    private static final Log log = LogFactory.getLog(AbstractShellService.class);
    private final Console console;
    private SessionManager sessionManager;
    private boolean verbose;
    private String greetings;
    private Token[] greetingsTokens;

    protected AbstractShellService(Console console) {
        super((ApplicationAdapter)new ShellApplicationAdapter());
        if (console == null) {
            throw new IllegalArgumentException("console must not be null");
        }
        this.console = console;
        this.determineBasePath();
    }

    public void afterContextLoaded() throws Exception {
        this.sessionManager = new DefaultSessionManager(this.getActivityContext());
        this.sessionManager.setGroupName("SH");
        SessionConfig sessionConfig = this.getAspectranConfig().getSessionConfig();
        if (sessionConfig != null) {
            this.sessionManager.setSessionConfig(sessionConfig);
        }
        this.sessionManager.initialize();
        this.parseGreetings();
    }

    public void beforeContextDestroy() {
        this.sessionManager.destroy();
        this.sessionManager = null;
    }

    @Override
    public SessionAdapter newSessionAdapter() {
        SessionAgent agent = this.sessionManager.newSessionAgent();
        return new ShellSessionAdapter(agent);
    }

    @Override
    public boolean isExposable(String transletName) {
        return super.isExposable(transletName);
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public String getGreetings() {
        return this.greetings;
    }

    @Override
    public void setGreetings(String greetings) {
        this.greetings = greetings;
    }

    @Override
    public void printGreetings() {
        if (this.greetingsTokens != null) {
            TokenExpression evaluator = new TokenExpression(this.getDefaultActivity());
            String message = evaluator.evaluateAsString(this.greetingsTokens);
            this.console.writeLine(message);
        } else if (this.greetings != null) {
            this.console.writeLine(this.greetings);
        }
    }

    private void parseGreetings() {
        if (StringUtils.hasText((String)this.greetings)) {
            this.greetingsTokens = TokenParser.makeTokens((String)this.greetings, (boolean)true);
            if (this.greetingsTokens != null) {
                try {
                    for (Token token : this.greetingsTokens) {
                        Token.resolveAlternativeValue((Token)token, (ClassLoader)this.getAspectranClassLoader());
                    }
                }
                catch (Exception e) {
                    this.greetingsTokens = null;
                    log.error("Failed to parse greetings", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void printHelp() {
        if (this.isVerbose() && this.getActivityContext().getDescription() != null) {
            this.console.writeLine(this.getActivityContext().getDescription());
        }
    }

    public void restart(String message) throws Exception {
        if (this.console.confirmRestart(message)) {
            super.restart(message);
        }
    }

    public boolean isBusy() {
        return this.console.isBusy();
    }
}

