/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.shell.service;

import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.activity.Translet;
import com.aspectran.core.activity.TransletNotFoundException;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.ContextConfig;
import com.aspectran.core.context.config.ExposalsConfig;
import com.aspectran.core.context.config.ShellConfig;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.service.AspectranServiceException;
import com.aspectran.core.service.ServiceStateListener;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Log;
import com.aspectran.core.util.logging.LogFactory;
import com.aspectran.shell.activity.ShellActivity;
import com.aspectran.shell.command.OutputRedirection;
import com.aspectran.shell.command.TransletCommandLine;
import com.aspectran.shell.console.Console;
import com.aspectran.shell.service.AbstractShellService;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;

public class AspectranShellService
extends AbstractShellService {
    private static final Log log = LogFactory.getLog(AspectranShellService.class);
    private static final String DEFAULT_APP_CONFIG_ROOT_FILE = "/config/app-config.xml";
    private long pauseTimeout = -1L;

    private AspectranShellService(Console console) {
        super(console);
    }

    @Override
    public Translet translate(TransletCommandLine transletCommandLine, Console console) {
        if (transletCommandLine == null) {
            throw new IllegalArgumentException("transletCommandLine must not be null");
        }
        if (console == null) {
            throw new IllegalArgumentException("console must not be null");
        }
        if (!this.isExposable(transletCommandLine.getRequestName())) {
            console.writeError("Unexposable translet: " + transletCommandLine.getRequestName());
            return null;
        }
        if (this.checkPaused(console)) {
            return null;
        }
        PrintWriter outputWriter = null;
        List<OutputRedirection> redirectionList = transletCommandLine.getLineParser().getRedirectionList();
        if (redirectionList != null) {
            try {
                outputWriter = OutputRedirection.determineOutputWriter(redirectionList, console);
            }
            catch (Exception e) {
                console.writeError("Invalid Output Redirection - " + e.getMessage());
                return null;
            }
        }
        boolean procedural = transletCommandLine.getParameterMap() == null;
        ParameterMap parameterMap = transletCommandLine.getParameterMap();
        String transletName = transletCommandLine.getRequestName();
        MethodType requestMethod = transletCommandLine.getRequestMethod();
        ShellActivity activity = null;
        Translet translet = null;
        try {
            activity = new ShellActivity(this, console);
            activity.setProcedural(procedural);
            activity.setParameterMap(parameterMap);
            activity.setOutputWriter(outputWriter);
            activity.prepare(transletName, requestMethod);
            activity.perform();
            translet = activity.getTranslet();
        }
        catch (ActivityTerminatedException e) {
            if (log.isDebugEnabled()) {
                log.debug("Activity terminated: " + e.getMessage());
            }
        }
        catch (TransletNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AspectranServiceException("An error occurred while processing translet: " + transletName, (Throwable)e);
        }
        finally {
            if (activity != null) {
                activity.finish();
            }
            if (outputWriter != null) {
                outputWriter.close();
            }
        }
        if (translet != null && outputWriter == null) {
            try {
                String result = translet.getResponseAdapter().getWriter().toString();
                if (StringUtils.hasLength((String)result)) {
                    console.writeLine(result);
                }
            }
            catch (IOException e) {
                log.warn("Failed to print activity result", (Throwable)e);
            }
        }
        return translet;
    }

    private boolean checkPaused(Console console) {
        if (this.pauseTimeout != 0L) {
            if (this.pauseTimeout == -1L || this.pauseTimeout >= System.currentTimeMillis()) {
                if (this.pauseTimeout == -1L) {
                    console.writeLine(this.getServiceName() + " has been paused");
                } else {
                    long remains = this.pauseTimeout - System.currentTimeMillis();
                    if (remains > 0L) {
                        console.writeLine(this.getServiceName() + " has been paused and will resume after " + remains + " ms");
                    } else {
                        console.writeLine(this.getServiceName() + " has been paused and will soon resume");
                    }
                }
                return true;
            }
            this.pauseTimeout = 0L;
        }
        return false;
    }

    public static AspectranShellService create(AspectranConfig aspectranConfig, Console console) {
        ContextConfig contextConfig = aspectranConfig.touchContextConfig();
        String rootFile = contextConfig.getRootFile();
        if (!StringUtils.hasText((String)rootFile) && !contextConfig.hasAspectranParameters()) {
            contextConfig.setRootFile(DEFAULT_APP_CONFIG_ROOT_FILE);
        }
        AspectranShellService service = new AspectranShellService(console);
        ShellConfig shellConfig = aspectranConfig.getShellConfig();
        if (shellConfig != null) {
            AspectranShellService.applyShellConfig(service, shellConfig);
        }
        service.prepare(aspectranConfig);
        AspectranShellService.setServiceStateListener(service);
        return service;
    }

    private static void applyShellConfig(AspectranShellService service, ShellConfig shellConfig) {
        service.setVerbose(shellConfig.isVerbose());
        service.setGreetings(shellConfig.getGreetings());
        ExposalsConfig exposalsConfig = shellConfig.getExposalsConfig();
        if (exposalsConfig != null) {
            String[] includePatterns = exposalsConfig.getIncludePatterns();
            String[] excludePatterns = exposalsConfig.getExcludePatterns();
            service.setExposals(includePatterns, excludePatterns);
        }
    }

    private static void setServiceStateListener(final AspectranShellService service) {
        service.setServiceStateListener(new ServiceStateListener(){

            public void started() {
                service.pauseTimeout = 0L;
                service.printGreetings();
                service.printHelp();
            }

            public void restarted() {
                this.started();
            }

            public void paused(long millis) {
                if (millis < 0L) {
                    throw new IllegalArgumentException("Pause timeout in milliseconds needs to be set to a value of greater than 0");
                }
                service.pauseTimeout = System.currentTimeMillis() + millis;
            }

            public void paused() {
                service.pauseTimeout = -1L;
            }

            public void resumed() {
                service.pauseTimeout = 0L;
            }

            public void stopped() {
                this.paused();
            }
        });
    }
}

