/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils;

import com.aspectran.utils.BeanDescriptor;
import com.aspectran.utils.ClassUtils;
import com.aspectran.utils.MethodUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class BeanUtils {
    private static final Object[] NO_ARGUMENTS = new Object[0];

    public static Object getProperty(Class<?> beanClass, String name) throws InvocationTargetException {
        try {
            BeanDescriptor bd = BeanUtils.getBeanDescriptor(beanClass);
            Method method = bd.getGetter(name);
            Object bean = null;
            if (!Modifier.isStatic(method.getModifiers())) {
                bean = ClassUtils.createInstance(beanClass);
            }
            try {
                return method.invoke(bean, NO_ARGUMENTS);
            }
            catch (Throwable t) {
                throw BeanUtils.unwrapThrowable(t);
            }
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new InvocationTargetException(t, "Could not get property '" + name + "' from " + beanClass.getName() + ". Cause: " + t);
        }
    }

    public static void setProperty(Class<?> beanClass, String name, Object value) throws InvocationTargetException {
        Object bean = null;
        try {
            BeanDescriptor bd = BeanUtils.getBeanDescriptor(beanClass);
            Method method = bd.getSetter(name);
            Object[] params = new Object[]{value};
            if (!Modifier.isStatic(method.getModifiers())) {
                bean = ClassUtils.createInstance(beanClass);
            }
            try {
                method.invoke(bean, params);
            }
            catch (Throwable t) {
                throw BeanUtils.unwrapThrowable(t);
            }
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Throwable t) {
            try {
                if (bean != null) {
                    MethodUtils.invokeSetter(bean, name, value);
                } else {
                    MethodUtils.invokeStaticMethod(beanClass, name, value);
                }
                return;
            }
            catch (Throwable throwable) {
                throw new InvocationTargetException(t, "Could not set property '" + name + "' to value '" + value + "' for " + beanClass.getName() + ". Cause: " + t);
            }
        }
    }

    public static boolean hasReadableProperty(Class<?> beanClass, String name) {
        try {
            BeanDescriptor bd = BeanUtils.getBeanDescriptor(beanClass);
            bd.getGetter(name);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean hasWritableProperty(Class<?> beanClass, String name) {
        try {
            BeanDescriptor bd = BeanUtils.getBeanDescriptor(beanClass);
            bd.getSetter(name);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean hasStaticReadableProperty(Class<?> beanClass, String name) {
        try {
            BeanDescriptor bd = BeanUtils.getBeanDescriptor(beanClass);
            Method method = bd.getGetter(name);
            return Modifier.isStatic(method.getModifiers());
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean hasStaticWritableProperty(Class<?> beanClass, String name) {
        try {
            BeanDescriptor bd = BeanUtils.getBeanDescriptor(beanClass);
            Method method = bd.getSetter(name);
            return Modifier.isStatic(method.getModifiers());
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static Object getProperty(Object bean, @NonNull String name) throws InvocationTargetException {
        if (name.contains(".")) {
            StringTokenizer parser = new StringTokenizer(name, ".");
            Object value = bean;
            while (parser.hasMoreTokens() && (value = BeanUtils.getSimpleProperty(value, parser.nextToken())) != null) {
            }
            return value;
        }
        return BeanUtils.getSimpleProperty(bean, name);
    }

    public static Object getSimpleProperty(Object bean, @NonNull String name) throws InvocationTargetException {
        try {
            Object value;
            if (name.contains("[")) {
                value = BeanUtils.getIndexedProperty(bean, name);
            } else if (bean instanceof Map) {
                value = ((Map)bean).get(name);
            } else {
                BeanDescriptor bd = BeanUtils.getBeanDescriptor(bean.getClass());
                Method method = bd.getGetter(name);
                try {
                    value = method.invoke(bean, NO_ARGUMENTS);
                }
                catch (Throwable t) {
                    throw BeanUtils.unwrapThrowable(t);
                }
            }
            return value;
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Throwable t) {
            if (bean == null) {
                throw new InvocationTargetException(t, "Could not get property '" + name + "' from null reference. Cause: " + t);
            }
            throw new InvocationTargetException(t, "Could not get property '" + name + "' from " + bean.getClass().getName() + ". Cause: " + t);
        }
    }

    public static void setProperty(Object bean, @NonNull String name, Object value) throws InvocationTargetException, NoSuchMethodException {
        if (name.contains(".")) {
            StringTokenizer parser = new StringTokenizer(name, ".");
            String newName = parser.nextToken();
            Object child = bean;
            while (parser.hasMoreTokens()) {
                Class<?> type = BeanUtils.getPropertyTypeForSetter(child, newName);
                Object parent = child;
                if ((child = BeanUtils.getSimpleProperty(parent, newName)) == null) {
                    if (value == null) {
                        return;
                    }
                    try {
                        child = ClassUtils.createInstance(type);
                        BeanUtils.setProperty(parent, newName, child);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e, "Cannot set value of property '" + name + "' because '" + newName + "' is null and cannot be instantiated on instance of " + type.getName() + ". Cause: " + e);
                    }
                }
                newName = parser.nextToken();
            }
            BeanUtils.setSimpleProperty(child, newName, value);
        } else {
            BeanUtils.setSimpleProperty(bean, name, value);
        }
    }

    public static void setSimpleProperty(Object bean, @NonNull String name, Object value) throws InvocationTargetException {
        block10: {
            try {
                if (name.contains("[")) {
                    BeanUtils.setIndexedProperty(bean, name, value);
                    break block10;
                }
                if (bean instanceof Map) {
                    Map map = (Map)bean;
                    map.put(name, value);
                    break block10;
                }
                BeanDescriptor bd = BeanUtils.getBeanDescriptor(bean.getClass());
                Method method = bd.getSetter(name);
                Object[] params = new Object[]{value};
                try {
                    method.invoke(bean, params);
                }
                catch (Throwable t) {
                    throw BeanUtils.unwrapThrowable(t);
                }
            }
            catch (InvocationTargetException e) {
                throw e;
            }
            catch (Throwable t) {
                try {
                    MethodUtils.invokeSetter(bean, name, value);
                    return;
                }
                catch (Throwable throwable) {
                    if (bean == null) {
                        throw new InvocationTargetException(t, "Could not set property '" + name + "' to value '" + value + "' for null reference. Cause: " + t);
                    }
                    throw new InvocationTargetException(t, "Could not set property '" + name + "' to value '" + value + "' for " + bean.getClass().getName() + ". Cause: " + t);
                }
            }
        }
    }

    public static Object getIndexedProperty(Object bean, @NonNull String indexedName) throws InvocationTargetException {
        try {
            Object value;
            Object list;
            String name = indexedName.substring(0, indexedName.indexOf("["));
            int index = Integer.parseInt(indexedName.substring(indexedName.indexOf("[") + 1, indexedName.indexOf("]")));
            Object object = list = !name.isEmpty() ? BeanUtils.getSimpleProperty(bean, name) : bean;
            if (list instanceof List) {
                value = ((List)list).get(index);
            } else if (list instanceof Object[]) {
                value = ((Object[])list)[index];
            } else if (list instanceof char[]) {
                value = Character.valueOf(((char[])list)[index]);
            } else if (list instanceof boolean[]) {
                value = ((boolean[])list)[index];
            } else if (list instanceof byte[]) {
                value = ((byte[])list)[index];
            } else if (list instanceof double[]) {
                value = ((double[])list)[index];
            } else if (list instanceof float[]) {
                value = Float.valueOf(((float[])list)[index]);
            } else if (list instanceof int[]) {
                value = ((int[])list)[index];
            } else if (list instanceof long[]) {
                value = ((long[])list)[index];
            } else if (list instanceof short[]) {
                value = ((short[])list)[index];
            } else {
                throw new IllegalArgumentException("The '" + name + "' property of the " + bean.getClass().getName() + " class is not a List or Array");
            }
            return value;
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvocationTargetException(e, "Error getting ordinal list from JavaBean. Cause: " + e);
        }
    }

    public static Class<?> getIndexedType(Object bean, @NonNull String indexedName) throws InvocationTargetException {
        try {
            Class<Object> value;
            Object list;
            String name = indexedName.substring(0, indexedName.indexOf("["));
            int i = Integer.parseInt(indexedName.substring(indexedName.indexOf("[") + 1, indexedName.indexOf("]")));
            Object object = list = !name.isEmpty() ? BeanUtils.getSimpleProperty(bean, name) : bean;
            if (list instanceof List) {
                value = ((List)list).get(i).getClass();
            } else if (list instanceof Object[]) {
                value = ((Object[])list)[i].getClass();
            } else if (list instanceof char[]) {
                value = Character.class;
            } else if (list instanceof boolean[]) {
                value = Boolean.class;
            } else if (list instanceof byte[]) {
                value = Byte.class;
            } else if (list instanceof double[]) {
                value = Double.class;
            } else if (list instanceof float[]) {
                value = Float.class;
            } else if (list instanceof int[]) {
                value = Integer.class;
            } else if (list instanceof long[]) {
                value = Long.class;
            } else if (list instanceof short[]) {
                value = Short.class;
            } else {
                throw new IllegalArgumentException("The '" + name + "' property of the " + bean.getClass().getName() + " class is not a List or Array");
            }
            return value;
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvocationTargetException(e, "Error getting ordinal list from JavaBean. Cause: " + e);
        }
    }

    public static void setIndexedProperty(Object bean, @NonNull String indexedName, Object value) throws InvocationTargetException {
        block13: {
            try {
                String name = indexedName.substring(0, indexedName.indexOf("["));
                int index = Integer.parseInt(indexedName.substring(indexedName.indexOf("[") + 1, indexedName.indexOf("]")));
                Object list = BeanUtils.getSimpleProperty(bean, name);
                if (list instanceof List) {
                    List l = (List)list;
                    l.set(index, value);
                    break block13;
                }
                if (list instanceof Object[]) {
                    ((Object[])list)[index] = value;
                    break block13;
                }
                if (list instanceof char[]) {
                    ((char[])list)[index] = ((Character)value).charValue();
                    break block13;
                }
                if (list instanceof boolean[]) {
                    ((boolean[])list)[index] = (Boolean)value;
                    break block13;
                }
                if (list instanceof byte[]) {
                    ((byte[])list)[index] = (Byte)value;
                    break block13;
                }
                if (list instanceof double[]) {
                    ((double[])list)[index] = (Double)value;
                    break block13;
                }
                if (list instanceof float[]) {
                    ((float[])list)[index] = ((Float)value).floatValue();
                    break block13;
                }
                if (list instanceof int[]) {
                    ((int[])list)[index] = (Integer)value;
                    break block13;
                }
                if (list instanceof long[]) {
                    ((long[])list)[index] = (Long)value;
                    break block13;
                }
                if (list instanceof short[]) {
                    ((short[])list)[index] = (Short)value;
                    break block13;
                }
                throw new IllegalArgumentException("The '" + name + "' property of the " + bean.getClass().getName() + " class is not a List or Array");
            }
            catch (InvocationTargetException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvocationTargetException(e, "Error getting ordinal value from JavaBean. Cause: " + e);
            }
        }
    }

    public static boolean hasWritableProperty(Object bean, @NonNull String name) throws NoSuchMethodException {
        boolean exists = false;
        if (bean instanceof Map) {
            exists = true;
        } else if (name.contains(".")) {
            StringTokenizer parser = new StringTokenizer(name, ".");
            Class<?> type = bean.getClass();
            while (parser.hasMoreTokens()) {
                name = parser.nextToken();
                type = BeanUtils.getBeanDescriptor(type).getGetterType(name);
                exists = BeanUtils.getBeanDescriptor(type).hasWritableProperty(name);
            }
        } else {
            exists = BeanUtils.getBeanDescriptor(bean.getClass()).hasWritableProperty(name);
        }
        return exists;
    }

    public static boolean hasReadableProperty(Object bean, @NonNull String name) throws NoSuchMethodException {
        boolean exists = false;
        if (bean instanceof Map) {
            exists = true;
        } else if (name.contains(".")) {
            StringTokenizer parser = new StringTokenizer(name, ".");
            Class<?> type = bean.getClass();
            while (parser.hasMoreTokens()) {
                name = parser.nextToken();
                type = BeanUtils.getBeanDescriptor(type).getGetterType(name);
                exists = BeanUtils.getBeanDescriptor(type).hasReadableProperty(name);
            }
        } else {
            exists = BeanUtils.getBeanDescriptor(bean.getClass()).hasReadableProperty(name);
        }
        return exists;
    }

    private static Throwable unwrapThrowable(Throwable t) {
        Throwable t2 = t;
        while (true) {
            if (t2 instanceof InvocationTargetException) {
                t2 = ((InvocationTargetException)t2).getTargetException();
                continue;
            }
            if (!(t2 instanceof UndeclaredThrowableException)) break;
            t2 = ((UndeclaredThrowableException)t2).getUndeclaredThrowable();
        }
        return t2;
    }

    public static Class<?> getPropertyTypeForSetter(@NonNull Object bean, String name) throws NoSuchMethodException {
        Class<Object> type = bean.getClass();
        if (bean instanceof Class) {
            type = BeanUtils.getClassPropertyTypeForSetter((Class)bean, name);
        } else if (bean instanceof Map) {
            Map map = (Map)bean;
            Object value = map.get(name);
            type = value == null ? Object.class : value.getClass();
        } else if (name.contains(".")) {
            StringTokenizer parser = new StringTokenizer(name, ".");
            while (parser.hasMoreTokens()) {
                name = parser.nextToken();
                type = BeanUtils.getBeanDescriptor(type).getSetterType(name);
            }
        } else {
            type = BeanUtils.getBeanDescriptor(type).getSetterType(name);
        }
        return type;
    }

    public static Class<?> getPropertyTypeForGetter(@NonNull Object bean, String name) throws NoSuchMethodException {
        Class<Object> type = bean.getClass();
        if (bean instanceof Class) {
            type = BeanUtils.getClassPropertyTypeForGetter((Class)bean, name);
        } else if (bean instanceof Map) {
            Map map = (Map)bean;
            Object value = map.get(name);
            type = value == null ? Object.class : value.getClass();
        } else if (name.contains(".")) {
            StringTokenizer parser = new StringTokenizer(name, ".");
            while (parser.hasMoreTokens()) {
                name = parser.nextToken();
                type = BeanUtils.getBeanDescriptor(type).getGetterType(name);
            }
        } else {
            type = BeanUtils.getBeanDescriptor(type).getGetterType(name);
        }
        return type;
    }

    public static Class<?> getClassPropertyTypeForGetter(Class<?> type, @NonNull String name) throws NoSuchMethodException {
        if (name.contains(".")) {
            StringTokenizer parser = new StringTokenizer(name, ".");
            while (parser.hasMoreTokens()) {
                name = parser.nextToken();
                type = BeanUtils.getBeanDescriptor(type).getGetterType(name);
            }
        } else {
            type = BeanUtils.getBeanDescriptor(type).getGetterType(name);
        }
        return type;
    }

    public static Class<?> getClassPropertyTypeForSetter(Class<?> type, @NonNull String name) throws NoSuchMethodException {
        if (name.contains(".")) {
            StringTokenizer parser = new StringTokenizer(name, ".");
            while (parser.hasMoreTokens()) {
                name = parser.nextToken();
                type = BeanUtils.getBeanDescriptor(type).getSetterType(name);
            }
        } else {
            type = BeanUtils.getBeanDescriptor(type).getSetterType(name);
        }
        return type;
    }

    public static String[] getReadablePropertyNames(@NonNull Object bean) {
        return BeanUtils.getBeanDescriptor(bean.getClass()).getReadablePropertyNames();
    }

    public static String[] getReadablePropertyNamesWithoutNonSerializable(@NonNull Object bean) {
        return BeanUtils.getBeanDescriptor(bean.getClass()).getReadablePropertyNamesWithoutNonSerializable();
    }

    public static String[] getWritablePropertyNames(@NonNull Object bean) {
        return BeanUtils.getBeanDescriptor(bean.getClass()).getWritablePropertyNames();
    }

    private static BeanDescriptor getBeanDescriptor(Class<?> beanClass) {
        return BeanDescriptor.getInstance(beanClass);
    }
}

