/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils;

import com.aspectran.utils.LinkedCaseInsensitiveMap;
import com.aspectran.utils.MultiValueMap;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public class LinkedCaseInsensitiveMultiValueMap<V>
implements MultiValueMap<String, V>,
Serializable {
    private static final long serialVersionUID = 2505523262093891621L;
    private final Map<String, List<V>> targetMap;

    public LinkedCaseInsensitiveMultiValueMap() {
        this.targetMap = new LinkedCaseInsensitiveMap<List<V>>(Locale.ENGLISH);
    }

    public LinkedCaseInsensitiveMultiValueMap(int initialCapacity) {
        this.targetMap = new LinkedCaseInsensitiveMap<List<V>>(initialCapacity, Locale.ENGLISH);
    }

    @Override
    public V getFirst(String key) {
        List<V> values = this.targetMap.get(key);
        return values != null ? (V)values.get(0) : null;
    }

    @Override
    public void add(String key, V value) {
        List values = this.targetMap.computeIfAbsent(key, k -> new LinkedList());
        values.add(value);
    }

    @Override
    public void addAll(String key, List<? extends V> values) {
        List currentValues = this.targetMap.computeIfAbsent(key, k -> new LinkedList());
        currentValues.addAll(values);
    }

    @Override
    public void addAll(MultiValueMap<String, V> values) {
        for (Map.Entry entry : values.entrySet()) {
            this.addAll((String)entry.getKey(), (List)entry.getValue());
        }
    }

    @Override
    public void set(String key, V value) {
        LinkedList<V> values = new LinkedList<V>();
        values.add(value);
        this.targetMap.put(key, values);
    }

    @Override
    public void set(String key, V[] values) {
        LinkedList list = new LinkedList();
        if (values != null) {
            Collections.addAll(list, values);
        }
        this.put(key, list);
    }

    @Override
    public void setAll(@NonNull Map<String, V> values) {
        for (Map.Entry<String, V> entry : values.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Map<String, V> toSingleValueMap() {
        LinkedHashMap<String, V> singleValueMap = new LinkedHashMap<String, V>(this.targetMap.size());
        for (Map.Entry<String, List<V>> entry : this.targetMap.entrySet()) {
            singleValueMap.put(entry.getKey(), entry.getValue().get(0));
        }
        return singleValueMap;
    }

    @Override
    public int size() {
        return this.targetMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.targetMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.targetMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.targetMap.containsValue(value);
    }

    @Override
    public List<V> get(Object key) {
        return this.targetMap.get(key);
    }

    @Override
    public List<V> put(String key, List<V> value) {
        return this.targetMap.put(key, value);
    }

    @Override
    public List<V> remove(Object key) {
        return this.targetMap.remove(key);
    }

    @Override
    public void putAll(@NonNull Map<? extends String, ? extends List<V>> map) {
        this.targetMap.putAll(map);
    }

    @Override
    public void clear() {
        this.targetMap.clear();
    }

    @Override
    @NonNull
    public Set<String> keySet() {
        return this.targetMap.keySet();
    }

    @Override
    @NonNull
    public Collection<List<V>> values() {
        return this.targetMap.values();
    }

    @Override
    @NonNull
    public Set<Map.Entry<String, List<V>>> entrySet() {
        return this.targetMap.entrySet();
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super List<V>> action) {
        this.targetMap.forEach(action);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LinkedCaseInsensitiveMultiValueMap)) {
            return false;
        }
        LinkedCaseInsensitiveMultiValueMap otherValues = (LinkedCaseInsensitiveMultiValueMap)other;
        return this.targetMap.equals(otherValues.targetMap);
    }

    @Override
    public int hashCode() {
        return this.targetMap.hashCode();
    }

    public String toString() {
        return this.targetMap.toString();
    }
}

