/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils.apon;

import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.apon.AponFormat;
import com.aspectran.utils.apon.ArrayParameters;
import com.aspectran.utils.apon.Parameter;
import com.aspectran.utils.apon.Parameters;
import com.aspectran.utils.apon.ValueType;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.Flushable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;

public class AponWriter
extends AponFormat
implements Flushable,
Closeable {
    private final Writer writer;
    private boolean autoFlush;
    private boolean prettyPrint;
    private String indentString;
    private boolean nullWritable = true;
    private boolean valueTypeHintEnabled;
    private int indentDepth;

    public AponWriter() {
        this(new StringWriter());
    }

    public AponWriter(Writer writer) {
        this.writer = writer;
        this.prettyPrint = true;
        this.setIndentString("  ");
    }

    public AponWriter(File file) throws IOException {
        this(new FileWriter(file));
    }

    public <T extends AponWriter> T autoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
        return (T)this;
    }

    public <T extends AponWriter> T prettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        if (prettyPrint) {
            this.setIndentString("  ");
        } else {
            this.setIndentString(null);
        }
        return (T)this;
    }

    public <T extends AponWriter> T indentString(String indentString) {
        this.setIndentString(indentString);
        return (T)this;
    }

    public <T extends AponWriter> T nullWritable(boolean nullWritable) {
        this.nullWritable = nullWritable;
        return (T)this;
    }

    public <T extends AponWriter> T enableValueTypeHints(boolean valueTypeHintEnabled) {
        this.valueTypeHintEnabled = valueTypeHintEnabled;
        return (T)this;
    }

    public void setIndentString(String indentString) {
        this.indentString = indentString;
    }

    public <T extends AponWriter> T write(Parameters parameters) throws IOException {
        if (parameters == null) {
            throw new IllegalArgumentException("parameters must not be null");
        }
        if (parameters instanceof ArrayParameters) {
            for (Parameters parameters2 : ((ArrayParameters)parameters).getParametersList()) {
                this.beginBlock();
                for (Parameter parameter : parameters2.getParameterValueMap().values()) {
                    if (!this.nullWritable && !parameter.isAssigned()) continue;
                    this.write(parameter);
                }
                this.endBlock();
            }
        } else {
            for (Parameter parameter : parameters.getParameterValueMap().values()) {
                if (!this.nullWritable && !parameter.isAssigned()) continue;
                this.write(parameter);
            }
        }
        return (T)this;
    }

    public <T extends AponWriter> T write(Parameter parameter) throws IOException {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter must not be null");
        }
        if (parameter.getValueType() == ValueType.PARAMETERS) {
            if (parameter.isArray()) {
                List<Parameters> list = parameter.getValueAsParametersList();
                if (list != null) {
                    if (parameter.isBracketed()) {
                        this.writeName(parameter);
                        this.beginArray();
                        for (Parameters ps : list) {
                            this.indent();
                            this.beginBlock();
                            if (ps != null) {
                                this.write(ps);
                            }
                            this.endBlock();
                        }
                        this.endArray();
                    } else {
                        for (Parameters ps : list) {
                            if (ps == null) continue;
                            this.writeName(parameter, ps.getActualName());
                            this.beginBlock();
                            this.write(ps);
                            this.endBlock();
                        }
                    }
                }
            } else {
                Parameters ps = parameter.getValueAsParameters();
                if (this.nullWritable || ps != null) {
                    this.writeName(parameter, ps != null ? ps.getActualName() : null);
                    this.beginBlock();
                    if (ps != null) {
                        this.write(ps);
                    }
                    this.endBlock();
                }
            }
        } else if (parameter.getValueType() == ValueType.VARIABLE) {
            if (parameter.isArray()) {
                List<?> list = parameter.getValueList();
                if (list != null) {
                    if (parameter.isBracketed()) {
                        this.writeName(parameter);
                        this.beginArray();
                        for (Object value : list) {
                            this.indent();
                            if (value instanceof Parameters) {
                                this.write((Parameters)value);
                                continue;
                            }
                            if (value != null) {
                                this.writeString(value.toString());
                                continue;
                            }
                            this.writeNull();
                        }
                        this.endArray();
                    } else {
                        for (Object value : list) {
                            this.writeName(parameter);
                            if (value instanceof Parameters) {
                                this.write((Parameters)value);
                                continue;
                            }
                            if (value != null) {
                                this.writeString(value.toString());
                                continue;
                            }
                            this.writeNull();
                        }
                    }
                }
            } else {
                Object value = parameter.getValue();
                if (this.nullWritable || value != null) {
                    this.writeName(parameter);
                    if (value instanceof Parameters) {
                        this.write((Parameters)value);
                    } else if (value != null) {
                        this.writeString(value.toString());
                    } else {
                        this.writeNull();
                    }
                }
            }
        } else if (parameter.getValueType() == ValueType.STRING) {
            if (parameter.isArray()) {
                List<String> list = parameter.getValueAsStringList();
                if (list != null) {
                    if (parameter.isBracketed()) {
                        this.writeName(parameter);
                        this.beginArray();
                        for (String value : list) {
                            this.indent();
                            this.writeString(value);
                        }
                        this.endArray();
                    } else {
                        for (String value : list) {
                            if (!this.nullWritable && value == null) continue;
                            this.writeName(parameter);
                            this.writeString(value);
                        }
                    }
                }
            } else {
                String value = parameter.getValueAsString();
                if (this.nullWritable || value != null) {
                    this.writeName(parameter);
                    this.writeString(value);
                }
            }
        } else if (parameter.getValueType() == ValueType.TEXT) {
            if (parameter.isArray()) {
                List<String> list = parameter.getValueAsStringList();
                if (list != null) {
                    if (parameter.isBracketed()) {
                        this.writeName(parameter);
                        this.beginArray();
                        for (String text : list) {
                            this.indent();
                            this.beginText();
                            this.writeText(text);
                            this.endText();
                        }
                        this.endArray();
                    } else {
                        for (String text : list) {
                            if (!this.nullWritable && text == null) continue;
                            this.writeName(parameter);
                            this.beginText();
                            this.writeText(text);
                            this.endText();
                        }
                    }
                }
            } else {
                String text = parameter.getValueAsString();
                if (text != null) {
                    this.writeName(parameter);
                    this.beginText();
                    this.writeText(text);
                    this.endText();
                } else if (this.nullWritable) {
                    this.writeName(parameter);
                    this.writeNull();
                }
            }
        } else if (parameter.isArray()) {
            List<?> list = parameter.getValueList();
            if (list != null) {
                if (parameter.isBracketed()) {
                    this.writeName(parameter);
                    this.beginArray();
                    for (Object value : list) {
                        this.indent();
                        this.write(value);
                    }
                    this.endArray();
                } else {
                    for (Object value : list) {
                        if (!this.nullWritable && value == null) continue;
                        this.writeName(parameter);
                        this.write(value);
                    }
                }
            }
        } else if (this.nullWritable || parameter.getValue() != null) {
            this.writeName(parameter);
            this.write(parameter.getValue());
        }
        return (T)this;
    }

    public <T extends AponWriter> T comment(String message) throws IOException {
        if (message != null) {
            if (message.indexOf(10) != -1) {
                String line;
                int start = 0;
                while ((line = this.readLine(message, start)) != null) {
                    this.writer.write(35);
                    this.writer.write(32);
                    this.writer.write(line);
                    this.newLine();
                    start += line.length();
                    if ((start = this.skipNewLineChar(message, start)) != -1) continue;
                }
                if (start != -1) {
                    this.writer.write(35);
                    this.newLine();
                }
            } else {
                this.writer.write(35);
                this.writer.write(32);
                this.writer.write(message);
                this.newLine();
            }
        }
        return (T)this;
    }

    private void writeName(Parameter parameter) throws IOException {
        this.writeName(parameter, null);
    }

    private void writeName(Parameter parameter, String actualName) throws IOException {
        this.indent();
        this.writer.write(actualName != null ? actualName : parameter.getName());
        if (this.valueTypeHintEnabled || parameter.isValueTypeHinted()) {
            this.writer.write(40);
            this.writer.write(parameter.getValueType().toString());
            this.writer.write(41);
        }
        this.writer.write(58);
        if (this.prettyPrint) {
            this.writer.write(32);
        }
    }

    private void writeString(String value) throws IOException {
        if (value == null) {
            this.writeNull();
            return;
        }
        if (value.isEmpty()) {
            this.writer.write(34);
            this.writer.write(34);
            this.newLine();
            return;
        }
        if (value.indexOf(34) >= 0 || value.indexOf(39) >= 0 || value.startsWith(" ") || value.endsWith(" ") || value.contains("\n")) {
            this.writer.write(34);
            this.writer.write(AponWriter.escape(value));
            this.writer.write(34);
        } else {
            this.writer.write(value);
        }
        this.newLine();
    }

    private void writeText(String text) throws IOException {
        String line;
        int start = 0;
        while ((line = this.readLine(text, start)) != null) {
            this.indent();
            this.writer.write(124);
            this.writer.write(line);
            this.newLine();
            start += line.length();
            if ((start = this.skipNewLineChar(text, start)) != -1) continue;
        }
        if (start != -1) {
            this.indent();
            this.writer.write(124);
            this.newLine();
        }
    }

    private void write(Object value) throws IOException {
        if (value != null) {
            this.writer.write(value.toString());
            this.newLine();
        } else {
            this.writeNull();
        }
    }

    private void writeNull() throws IOException {
        this.writer.write("null");
        this.newLine();
    }

    private void beginBlock() throws IOException {
        this.writer.write(123);
        this.newLine();
        this.increaseIndent();
    }

    private void endBlock() throws IOException {
        this.decreaseIndent();
        this.indent();
        this.writer.write(125);
        this.newLine();
    }

    private void beginArray() throws IOException {
        this.writer.write(91);
        this.newLine();
        this.increaseIndent();
    }

    private void endArray() throws IOException {
        this.decreaseIndent();
        this.indent();
        this.writer.write(93);
        this.newLine();
    }

    private void beginText() throws IOException {
        this.writer.write(40);
        this.newLine();
        this.increaseIndent();
    }

    private void endText() throws IOException {
        this.decreaseIndent();
        this.indent();
        this.writer.write(41);
        this.newLine();
    }

    private void newLine() throws IOException {
        this.writer.write(SYSTEM_NEW_LINE);
        if (this.autoFlush) {
            this.flush();
        }
    }

    private void indent() throws IOException {
        if (this.indentString != null) {
            for (int i = 0; i < this.indentDepth; ++i) {
                this.writer.write(this.indentString);
            }
        }
    }

    private void increaseIndent() {
        if (this.indentString != null) {
            ++this.indentDepth;
        }
    }

    private void decreaseIndent() {
        if (this.indentString != null) {
            --this.indentDepth;
        }
    }

    @Nullable
    private String readLine(@NonNull String value, int start) {
        char c;
        int end;
        if (start >= value.length()) {
            return null;
        }
        for (end = start; end < value.length() && (c = value.charAt(end)) != '\n' && c != '\r'; ++end) {
        }
        return end > start ? value.substring(start, end) : "";
    }

    private int skipNewLineChar(@NonNull String value, int start) {
        char c;
        int end;
        boolean cr = false;
        boolean lf = false;
        for (end = start; !(end >= value.length() || (c = value.charAt(end)) != '\n' && c != '\r' || lf && c == '\n' || cr && c == '\r'); ++end) {
            if (c == '\n') {
                lf = true;
            }
            if (c != '\r') continue;
            cr = true;
        }
        return end > start ? end : -1;
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }

    public String toString() {
        return this.writer.toString();
    }

    public static String escape(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return str;
        }
        StringBuilder sb = new StringBuilder(len);
        block8: for (int pos = 0; pos < len; ++pos) {
            char c = str.charAt(pos);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block8;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block8;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block8;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

