/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils.apon;

import com.aspectran.utils.BeanUtils;
import com.aspectran.utils.apon.InvalidParameterValueException;
import com.aspectran.utils.apon.Parameters;
import com.aspectran.utils.apon.VariableParameters;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class ObjectToAponConverter {
    private String dateFormat;
    private String dateTimeFormat;

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public ObjectToAponConverter dateFormat(String dateFormat) {
        this.setDateFormat(dateFormat);
        return this;
    }

    public ObjectToAponConverter dateTimeFormat(String dateTimeFormat) {
        this.setDateTimeFormat(dateTimeFormat);
        return this;
    }

    public Parameters toParameters(Object object) {
        return this.toParameters(null, object);
    }

    public Parameters toParameters(String name, Object object) {
        VariableParameters container = new VariableParameters();
        this.putValue(container, name, object);
        return container;
    }

    public void putValue(Parameters container, Object value) {
        this.putValue(container, null, value);
    }

    public void putValue(Parameters container, String name, Object value) {
        if (name == null) {
            Object o = this.valuelize(value);
            if (o instanceof Parameters) {
                container.putAll((Parameters)o);
            }
        } else if (value == null) {
            if (container.hasParameter(name)) {
                container.removeValue(name);
            }
            container.putValue(name, null);
        } else if (value instanceof Collection) {
            if (container.hasParameter(name)) {
                container.removeValue(name);
            }
            for (Object o : (Collection)value) {
                if (o == null) continue;
                this.putValue(container, name, o);
            }
            if (!container.hasParameter(name)) {
                container.putValue(name, null);
            }
        } else if (value.getClass().isArray()) {
            if (container.hasParameter(name)) {
                container.removeValue(name);
            }
            int len = Array.getLength(value);
            for (int i = 0; i < len; ++i) {
                Object o = Array.get(value, i);
                if (o == null) continue;
                this.putValue(container, name, o);
            }
            if (!container.hasParameter(name)) {
                container.putValue(name, null);
            }
        } else {
            container.putValue(name, this.valuelize(value));
        }
    }

    private Object valuelize(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Parameters || object instanceof String || object instanceof Number || object instanceof Boolean) {
            return object;
        }
        if (object instanceof Character) {
            return String.valueOf(((Character)object).charValue());
        }
        if (object instanceof Map) {
            VariableParameters ps = new VariableParameters();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                String name = entry.getKey().toString();
                Object value = entry.getValue();
                this.checkCircularReference(object, value);
                this.putValue(ps, name, value);
            }
            return ps;
        }
        if (object instanceof Collection || object.getClass().isArray()) {
            return object.toString();
        }
        if (object instanceof Date) {
            if (this.dateTimeFormat != null) {
                SimpleDateFormat dt = new SimpleDateFormat(this.dateTimeFormat);
                return dt.format((Date)object);
            }
            return object.toString();
        }
        if (object instanceof LocalDate) {
            if (this.dateFormat != null) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.dateFormat);
                return ((LocalDate)object).format(formatter);
            }
            return object.toString();
        }
        if (object instanceof LocalDateTime) {
            if (this.dateTimeFormat != null) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.dateTimeFormat);
                return ((LocalDateTime)object).format(formatter);
            }
            return object.toString();
        }
        String[] readablePropertyNames = BeanUtils.getReadablePropertyNamesWithoutNonSerializable(object);
        if (readablePropertyNames != null && readablePropertyNames.length > 0) {
            VariableParameters ps = new VariableParameters();
            for (String name : readablePropertyNames) {
                Object value;
                try {
                    value = BeanUtils.getProperty(object, name);
                }
                catch (InvocationTargetException e) {
                    throw new InvalidParameterValueException(e);
                }
                this.checkCircularReference(object, value);
                this.putValue(ps, name, value);
            }
            return ps;
        }
        return object.toString();
    }

    private void checkCircularReference(Object wrapper, Object member) {
        if (wrapper.equals(member)) {
            throw new InvalidParameterValueException("APON Serialization Failure: A circular reference was detected while converting a member object [" + member + "] in [" + wrapper + "]");
        }
    }
}

