/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils.apon;

import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.apon.AbstractParameters;
import com.aspectran.utils.apon.ParameterValue;
import com.aspectran.utils.apon.ValueType;

public class ParameterKey {
    private final String name;
    private final String[] altNames;
    private final ValueType valueType;
    private final Class<? extends AbstractParameters> parametersClass;
    private final boolean array;
    private final boolean noBrackets;

    public ParameterKey(String name, ValueType valueType) {
        this(name, null, valueType);
    }

    public ParameterKey(String name, String[] altNames, ValueType valueType) {
        this(name, altNames, valueType, false);
    }

    public ParameterKey(String name, ValueType valueType, boolean array) {
        this(name, null, valueType, array);
    }

    public ParameterKey(String name, String[] altNames, ValueType valueType, boolean array) {
        this(name, altNames, valueType, array, false);
    }

    public ParameterKey(String name, ValueType valueType, boolean array, boolean noBrackets) {
        this(name, null, valueType, array, noBrackets);
    }

    public ParameterKey(String name, String[] altNames, ValueType valueType, boolean array, boolean noBrackets) {
        this.name = name;
        this.altNames = altNames;
        this.valueType = valueType;
        this.parametersClass = null;
        this.array = array;
        this.noBrackets = array && valueType == ValueType.PARAMETERS && noBrackets;
    }

    public ParameterKey(String name, Class<? extends AbstractParameters> parametersClass) {
        this(name, null, parametersClass);
    }

    public ParameterKey(String name, String[] altNames, Class<? extends AbstractParameters> parametersClass) {
        this(name, altNames, parametersClass, false);
    }

    public ParameterKey(String name, Class<? extends AbstractParameters> parametersClass, boolean array) {
        this(name, null, parametersClass, array);
    }

    public ParameterKey(String name, String[] altNames, Class<? extends AbstractParameters> parametersClass, boolean array) {
        this(name, altNames, parametersClass, array, false);
    }

    public ParameterKey(String name, Class<? extends AbstractParameters> parametersClass, boolean array, boolean noBrackets) {
        this(name, null, parametersClass, array, noBrackets);
    }

    public ParameterKey(String name, String[] altNames, Class<? extends AbstractParameters> parametersClass, boolean array, boolean noBrackets) {
        this.name = name;
        this.altNames = altNames;
        this.valueType = ValueType.PARAMETERS;
        this.parametersClass = parametersClass;
        this.array = array;
        this.noBrackets = array && noBrackets;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAltNames() {
        return this.altNames;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public boolean isArray() {
        return this.array;
    }

    public boolean isNoBrackets() {
        return this.noBrackets;
    }

    public ParameterValue newParameterValue() {
        ParameterValue parameterValue = this.valueType == ValueType.PARAMETERS && this.parametersClass != null ? new ParameterValue(this.name, this.parametersClass, this.array, this.noBrackets, true) : new ParameterValue(this.name, this.valueType, this.array, this.noBrackets, true);
        return parameterValue;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("name", this.name);
        tsb.append("altNames", this.altNames);
        tsb.append("valueType", (Object)this.valueType);
        tsb.append("class", this.parametersClass);
        tsb.append("array", this.array);
        return tsb.toString();
    }
}

