/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils.apon;

import com.aspectran.utils.Assert;
import com.aspectran.utils.ClassUtils;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.apon.AbstractParameters;
import com.aspectran.utils.apon.AponParseException;
import com.aspectran.utils.apon.AponReader;
import com.aspectran.utils.apon.IncompatibleValueTypeException;
import com.aspectran.utils.apon.InvalidParameterValueException;
import com.aspectran.utils.apon.Parameter;
import com.aspectran.utils.apon.Parameters;
import com.aspectran.utils.apon.ValueType;
import com.aspectran.utils.apon.ValueTypeMismatchException;
import com.aspectran.utils.apon.VariableParameters;
import java.util.ArrayList;
import java.util.List;

public class ParameterValue
implements Parameter {
    private Parameters container;
    private final String name;
    private final ValueType originValueType;
    private ValueType valueType;
    private final boolean valueTypeFixed;
    private boolean valueTypeHinted;
    private Class<? extends AbstractParameters> parametersClass;
    private boolean array;
    private boolean bracketed;
    private volatile Object value;
    private List<Object> list;
    private boolean assigned;

    public ParameterValue(String name, ValueType valueType) {
        this(name, valueType, false);
    }

    public ParameterValue(String name, ValueType valueType, boolean array) {
        this(name, valueType, array, false);
    }

    public ParameterValue(String name, ValueType valueType, boolean array, boolean noBracket) {
        this(name, valueType, array, noBracket, false);
    }

    protected ParameterValue(String name, ValueType valueType, boolean array, boolean noBracket, boolean valueTypeFixed) {
        this.name = name;
        this.valueType = valueType;
        this.originValueType = valueType;
        this.array = array;
        boolean bl = this.valueTypeFixed = valueTypeFixed && valueType != ValueType.VARIABLE;
        if (this.array && !noBracket) {
            this.bracketed = true;
        }
    }

    public ParameterValue(String name, Class<? extends AbstractParameters> parametersClass) {
        this(name, parametersClass, false);
    }

    public ParameterValue(String name, Class<? extends AbstractParameters> parametersClass, boolean array) {
        this(name, parametersClass, array, false);
    }

    public ParameterValue(String name, Class<? extends AbstractParameters> parametersClass, boolean array, boolean noBracket) {
        this(name, parametersClass, array, noBracket, false);
    }

    protected ParameterValue(String name, Class<? extends AbstractParameters> parametersClass, boolean array, boolean noBracket, boolean valueTypeFixed) {
        this.name = name;
        this.originValueType = this.valueType = ValueType.PARAMETERS;
        this.parametersClass = parametersClass;
        this.array = array;
        this.valueTypeFixed = valueTypeFixed;
        if (this.array && !noBracket) {
            this.bracketed = true;
        }
    }

    @Override
    public Parameters getContainer() {
        return this.container;
    }

    public void setContainer(Parameters container) {
        this.container = container;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        if (this.container == null) {
            return this.name;
        }
        Parameter prototype = this.container.getProprietor();
        if (prototype != null) {
            return prototype.getQualifiedName() + "." + this.name;
        }
        return this.name;
    }

    @Override
    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public void setValueType(ValueType valueType) {
        this.valueType = valueType;
    }

    @Override
    public boolean isValueTypeFixed() {
        return this.valueTypeFixed;
    }

    @Override
    public boolean isValueTypeHinted() {
        return this.valueTypeHinted;
    }

    @Override
    public void setValueTypeHinted(boolean valueTypeHinted) {
        this.valueTypeHinted = valueTypeHinted;
    }

    @Override
    public boolean isArray() {
        return this.array;
    }

    @Override
    public boolean isBracketed() {
        return this.bracketed;
    }

    public void setBracketed(boolean bracketed) {
        this.bracketed = bracketed;
    }

    @Override
    public boolean isAssigned() {
        return this.assigned;
    }

    @Override
    public boolean hasValue() {
        if (this.assigned) {
            if (this.array) {
                return this.list != null;
            }
            return this.value != null;
        }
        return false;
    }

    @Override
    public int getArraySize() {
        List<?> list = this.getValueList();
        return list != null ? list.size() : 0;
    }

    @Override
    public void arraylize() {
        Assert.state(!this.assigned, "This parameter cannot be converted to an array type because it already has a value assigned to it");
        this.array = true;
        this.bracketed = true;
    }

    @Override
    public void putValue(Object value) {
        if (value != null) {
            if (this.valueTypeFixed) {
                value = this.determineValue(value);
            } else {
                this.determineValueType(value);
            }
        }
        if (!this.valueTypeFixed && !this.array && this.value != null) {
            this.addValue(this.value);
            this.addValue(value);
            this.value = null;
            this.array = true;
            this.bracketed = true;
        } else if (this.array) {
            this.addValue(value);
        } else {
            this.value = value;
            this.assigned = true;
        }
    }

    private synchronized void addValue(Object value) {
        if (this.list == null) {
            this.list = new ArrayList<Object>();
            this.assigned = true;
        }
        this.list.add(value);
    }

    @Override
    public void removeValue() {
        this.value = null;
        this.list = null;
        this.assigned = false;
        if (!this.valueTypeFixed) {
            this.array = false;
            this.bracketed = false;
        }
    }

    @Override
    public Object getValue() {
        return this.array ? this.getValueList() : this.value;
    }

    @Override
    public List<?> getValueList() {
        if (!this.valueTypeFixed && this.value != null && this.list == null && this.originValueType == ValueType.VARIABLE) {
            this.addValue(this.value);
        }
        return this.list;
    }

    @Override
    public Object[] getValues() {
        List<?> list = this.getValueList();
        return list != null ? list.toArray(new Object[0]) : null;
    }

    @Override
    public String getValueAsString() {
        return this.value != null ? this.value.toString() : null;
    }

    @Override
    public String[] getValueAsStringArray() {
        if (this.array) {
            List<?> list = this.getValueList();
            if (list != null) {
                String[] s = new String[list.size()];
                for (int i = 0; i < s.length; ++i) {
                    s[i] = list.get(i).toString();
                }
                return s;
            }
            return null;
        }
        if (this.value != null) {
            return new String[]{this.value.toString()};
        }
        return null;
    }

    @Override
    public List<String> getValueAsStringList() {
        if (this.valueType == ValueType.STRING) {
            return this.getValueList();
        }
        List<?> list1 = this.getValueList();
        if (list1 != null) {
            ArrayList<String> list2 = new ArrayList<String>();
            for (Object o : list1) {
                list2.add(o.toString());
            }
            return list2;
        }
        return null;
    }

    @Override
    public Integer getValueAsInt() {
        this.checkValueType(ValueType.INT);
        return (Integer)this.value;
    }

    @Override
    public Integer[] getValueAsIntArray() {
        List<Integer> intList = this.getValueAsIntList();
        return intList != null ? intList.toArray(new Integer[0]) : null;
    }

    @Override
    public List<Integer> getValueAsIntList() {
        this.checkValueType(ValueType.INT);
        return this.getValueList();
    }

    @Override
    public Long getValueAsLong() {
        this.checkValueType(ValueType.LONG);
        return (Long)this.value;
    }

    @Override
    public Long[] getValueAsLongArray() {
        List<Long> longList = this.getValueAsLongList();
        return longList != null ? longList.toArray(new Long[0]) : null;
    }

    @Override
    public List<Long> getValueAsLongList() {
        this.checkValueType(ValueType.LONG);
        return this.getValueList();
    }

    @Override
    public Float getValueAsFloat() {
        this.checkValueType(ValueType.FLOAT);
        return (Float)this.value;
    }

    @Override
    public Float[] getValueAsFloatArray() {
        List<Float> floatList = this.getValueAsFloatList();
        return floatList != null ? floatList.toArray(new Float[0]) : null;
    }

    @Override
    public List<Float> getValueAsFloatList() {
        this.checkValueType(ValueType.FLOAT);
        return this.getValueList();
    }

    @Override
    public Double getValueAsDouble() {
        this.checkValueType(ValueType.DOUBLE);
        return (Double)this.value;
    }

    @Override
    public Double[] getValueAsDoubleArray() {
        List<Double> doubleList = this.getValueAsDoubleList();
        return doubleList != null ? doubleList.toArray(new Double[0]) : null;
    }

    @Override
    public List<Double> getValueAsDoubleList() {
        this.checkValueType(ValueType.DOUBLE);
        return this.getValueList();
    }

    @Override
    public Boolean getValueAsBoolean() {
        this.checkValueType(ValueType.BOOLEAN);
        return (Boolean)this.value;
    }

    @Override
    public Boolean[] getValueAsBooleanArray() {
        List<Boolean> booleanList = this.getValueAsBooleanList();
        return booleanList != null ? booleanList.toArray(new Boolean[0]) : null;
    }

    @Override
    public List<Boolean> getValueAsBooleanList() {
        this.checkValueType(ValueType.BOOLEAN);
        return this.getValueList();
    }

    @Override
    public Parameters getValueAsParameters() {
        this.checkValueType(ValueType.PARAMETERS);
        return (Parameters)this.value;
    }

    @Override
    public Parameters[] getValueAsParametersArray() {
        List<Parameters> parametersList = this.getValueAsParametersList();
        return parametersList != null ? parametersList.toArray(new Parameters[0]) : null;
    }

    @Override
    public List<Parameters> getValueAsParametersList() {
        if (this.valueType != ValueType.PARAMETERS) {
            throw new IncompatibleValueTypeException(this, ValueType.PARAMETERS);
        }
        return this.getValueList();
    }

    @Override
    public <T extends Parameters> T newParameters(Parameter identifier) {
        if (this.valueType == ValueType.VARIABLE) {
            this.valueType = ValueType.PARAMETERS;
            this.parametersClass = VariableParameters.class;
        } else {
            this.checkValueType(ValueType.PARAMETERS);
            if (this.parametersClass == null) {
                this.parametersClass = VariableParameters.class;
            }
        }
        try {
            Parameters p = ClassUtils.createInstance(this.parametersClass);
            p.setProprietor(identifier);
            this.putValue(p);
            return (T)p;
        }
        catch (Exception e) {
            throw new InvalidParameterValueException("Failed to instantiate " + this.parametersClass, e);
        }
    }

    private void checkValueType(ValueType valueType) {
        if (this.valueType != ValueType.VARIABLE && this.valueType != valueType) {
            throw new IncompatibleValueTypeException(this, valueType);
        }
    }

    private void determineValueType(Object value) {
        if (this.valueType == ValueType.STRING) {
            if (value.toString().contains("\n")) {
                this.valueType = ValueType.TEXT;
            }
        } else if (this.valueType == ValueType.VARIABLE) {
            if (value instanceof CharSequence) {
                this.valueType = value.toString().contains("\n") ? ValueType.TEXT : ValueType.STRING;
            } else if (value instanceof Character) {
                this.valueType = ValueType.STRING;
            }
        }
    }

    private Object determineValue(Object value) {
        if (this.valueType == ValueType.STRING || this.valueType == ValueType.TEXT) {
            return ((Object)value).toString();
        }
        if (this.valueType == ValueType.BOOLEAN) {
            if (!(value instanceof Boolean)) {
                return Boolean.valueOf(((Object)value).toString());
            }
        } else if (this.valueType == ValueType.INT) {
            if (!(value instanceof Integer)) {
                try {
                    return Integer.valueOf(((Object)value).toString());
                }
                catch (NumberFormatException e) {
                    throw new ValueTypeMismatchException(value.getClass(), Integer.class, e);
                }
            }
        } else if (this.valueType == ValueType.LONG) {
            if (!(value instanceof Long)) {
                try {
                    return Long.valueOf(((Object)value).toString());
                }
                catch (NumberFormatException e) {
                    throw new ValueTypeMismatchException(value.getClass(), Long.class, e);
                }
            }
        } else if (this.valueType == ValueType.FLOAT) {
            if (!(value instanceof Float)) {
                try {
                    return Float.valueOf(((Object)value).toString());
                }
                catch (NumberFormatException e) {
                    throw new ValueTypeMismatchException(value.getClass(), Float.class, e);
                }
            }
        } else if (this.valueType == ValueType.DOUBLE) {
            if (!(value instanceof Double)) {
                try {
                    return Double.valueOf(((Object)value).toString());
                }
                catch (NumberFormatException e) {
                    throw new ValueTypeMismatchException(value.getClass(), Double.class, e);
                }
            }
        } else if (this.valueType == ValueType.PARAMETERS && !(value instanceof Parameters)) {
            try {
                value = AponReader.parse(((Object)value).toString(), this.parametersClass);
            }
            catch (AponParseException e) {
                throw new ValueTypeMismatchException(value.getClass(), this.parametersClass, e);
            }
        }
        return value;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("name", this.name);
        tsb.append("valueType", (Object)this.valueType);
        tsb.append("array", this.array);
        if (this.array) {
            tsb.append("arraySize", this.getArraySize());
        }
        tsb.append("bracketed", this.bracketed);
        tsb.append("qualifiedName", this.getQualifiedName());
        if (this.valueType == ValueType.PARAMETERS) {
            tsb.append("class", this.parametersClass);
        }
        return tsb.toString();
    }
}

