/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils.lifecycle;

import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.lifecycle.LifeCycle;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.utils.thread.AutoLock;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractLifeCycle
implements LifeCycle {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLifeCycle.class);
    private final CopyOnWriteArrayList<LifeCycle.Listener> listeners = new CopyOnWriteArrayList();
    private final AutoLock lock = new AutoLock();
    private static final int STATE_FAILED = -1;
    private static final int STATE_STOPPED = 0;
    private static final int STATE_STARTING = 1;
    private static final int STATE_STARTED = 2;
    private static final int STATE_STOPPING = 3;
    private volatile int state = 0;

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    /*
     * Loose catch block
     */
    @Override
    public final void start() throws Exception {
        AutoLock ignored;
        block10: {
            ignored = this.lock.lock();
            if (this.state != 2 && this.state != 1) break block10;
            if (ignored != null) {
                ignored.close();
            }
            return;
            {
                catch (Throwable e) {
                    this.setFailed(e);
                    throw e;
                }
            }
        }
        try {
            this.setStarting();
            this.doStart();
            this.setStarted();
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public final void stop() throws Exception {
        AutoLock ignored;
        block10: {
            ignored = this.lock.lock();
            if (this.state != 3 && this.state != 0) break block10;
            if (ignored != null) {
                ignored.close();
            }
            return;
            {
                catch (Throwable e) {
                    this.setFailed(e);
                    throw e;
                }
            }
        }
        try {
            this.setStopping();
            this.doStop();
            this.setStopped();
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
    }

    @Override
    public boolean isRunning() {
        int state = this.state;
        return state == 2 || state == 1;
    }

    @Override
    public boolean isStarted() {
        return this.state == 2;
    }

    @Override
    public boolean isStarting() {
        return this.state == 1;
    }

    @Override
    public boolean isStopping() {
        return this.state == 3;
    }

    @Override
    public boolean isStopped() {
        return this.state == 0;
    }

    @Override
    public boolean isFailed() {
        return this.state == -1;
    }

    @Override
    public void addLifeCycleListener(LifeCycle.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeLifeCycleListener(LifeCycle.Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public String getState() {
        switch (this.state) {
            case -1: {
                return "FAILED";
            }
            case 1: {
                return "STARTING";
            }
            case 2: {
                return "STARTED";
            }
            case 3: {
                return "STOPPING";
            }
            case 0: {
                return "STOPPED";
            }
        }
        return null;
    }

    public static String getState(@NonNull LifeCycle lc) {
        if (lc.isStarting()) {
            return "STARTING";
        }
        if (lc.isStarted()) {
            return "STARTED";
        }
        if (lc.isStopping()) {
            return "STOPPING";
        }
        if (lc.isStopped()) {
            return "STOPPED";
        }
        return "FAILED";
    }

    private void setStarted() {
        this.state = 2;
        if (logger.isDebugEnabled()) {
            logger.debug("STARTED " + this);
        }
        for (LifeCycle.Listener listener : this.listeners) {
            listener.lifeCycleStarted(this);
        }
    }

    private void setStarting() {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting " + this);
        }
        this.state = 1;
        for (LifeCycle.Listener listener : this.listeners) {
            listener.lifeCycleStarting(this);
        }
    }

    private void setStopping() {
        if (logger.isDebugEnabled()) {
            logger.debug("Stopping " + this);
        }
        this.state = 3;
        for (LifeCycle.Listener listener : this.listeners) {
            listener.lifeCycleStopping(this);
        }
    }

    private void setStopped() {
        this.state = 0;
        if (logger.isDebugEnabled()) {
            logger.debug("STOPPED " + this);
        }
        for (LifeCycle.Listener listener : this.listeners) {
            listener.lifeCycleStopped(this);
        }
    }

    private void setFailed(Throwable th) {
        this.state = -1;
        if (logger.isDebugEnabled()) {
            logger.warn("FAILED " + this + ": " + th, th);
        }
        for (LifeCycle.Listener listener : this.listeners) {
            listener.lifeCycleFailure(this, th);
        }
    }

    public String toString() {
        Class<?> clazz = this.getClass();
        String name = clazz.getSimpleName();
        if (StringUtils.isEmpty(name) && clazz.getSuperclass() != null) {
            clazz = clazz.getSuperclass();
            name = clazz.getSimpleName();
        }
        return String.format("%s@%x{%s}", name, this.hashCode(), this.getState());
    }
}

