/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils.lifecycle;

import java.util.EventListener;

public interface LifeCycle {
    public static final String STOPPED = "STOPPED";
    public static final String FAILED = "FAILED";
    public static final String STARTING = "STARTING";
    public static final String STARTED = "STARTED";
    public static final String STOPPING = "STOPPING";
    public static final String RUNNING = "RUNNING";

    public void start() throws Exception;

    public void stop() throws Exception;

    public boolean isRunning();

    public boolean isStarted();

    public boolean isStarting();

    public boolean isStopping();

    public boolean isStopped();

    public boolean isFailed();

    public void addLifeCycleListener(Listener var1);

    public void removeLifeCycleListener(Listener var1);

    public String getState();

    public static void start(Object object) {
        if (object instanceof LifeCycle) {
            try {
                ((LifeCycle)object).start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void stop(Object object) {
        if (object instanceof LifeCycle) {
            try {
                ((LifeCycle)object).stop();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface Listener
    extends EventListener {
        default public void lifeCycleStarting(LifeCycle event) {
        }

        default public void lifeCycleStarted(LifeCycle event) {
        }

        default public void lifeCycleFailure(LifeCycle event, Throwable cause) {
        }

        default public void lifeCycleStopping(LifeCycle event) {
        }

        default public void lifeCycleStopped(LifeCycle event) {
        }
    }
}

