/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils;

import java.util.ArrayList;
import java.util.EmptyStackException;

public class ArrayStack<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 4952513157310856314L;

    public ArrayStack() {
    }

    public ArrayStack(int initialSize) {
        super(initialSize);
    }

    public E peek() throws EmptyStackException {
        int n = this.size();
        if (n == 0) {
            throw new EmptyStackException();
        }
        return this.get(n - 1);
    }

    public E peek(int n) throws EmptyStackException {
        int m = this.size() - n - 1;
        if (m < 0) {
            throw new EmptyStackException();
        }
        return this.get(m);
    }

    public E peek(Class<?> target) throws EmptyStackException {
        for (int i = this.size() - 1; i >= 0; --i) {
            Object item = this.get(i);
            if (!item.getClass().equals(target)) continue;
            return item;
        }
        throw new EmptyStackException();
    }

    public E pop() throws EmptyStackException {
        int n = this.size();
        if (n == 0) {
            throw new EmptyStackException();
        }
        return this.remove(n - 1);
    }

    public E push(E item) {
        this.add(item);
        return item;
    }

    public E update(E item) throws EmptyStackException {
        int n = this.size();
        if (n == 0) {
            throw new EmptyStackException();
        }
        return this.set(n - 1, item);
    }

    public E update(int n, E item) throws EmptyStackException {
        int m = this.size() - n - 1;
        if (m < 0) {
            throw new EmptyStackException();
        }
        return this.set(m, item);
    }

    public int search(E object) {
        int i = this.size() - 1;
        int n = 1;
        while (i >= 0) {
            Object current = this.get(i);
            if (object == null && current == null || object != null && object.equals(current)) {
                return n;
            }
            --i;
            ++n;
        }
        return -1;
    }
}

