/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils;

import com.aspectran.utils.annotation.jsr305.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class DigestUtils {
    private static final String MD5_ALGORITHM_NAME = "MD5";
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final int BUFFER_SIZE = 4096;

    public static byte[] md5Digest(byte[] bytes) {
        return DigestUtils.digest(MD5_ALGORITHM_NAME, bytes);
    }

    public static byte[] md5Digest(InputStream inputStream) throws IOException {
        return DigestUtils.digest(MD5_ALGORITHM_NAME, inputStream);
    }

    @NonNull
    public static String md5DigestAsHex(byte[] bytes) {
        return DigestUtils.digestAsHexString(MD5_ALGORITHM_NAME, bytes);
    }

    @NonNull
    public static String md5DigestAsHex(InputStream inputStream) throws IOException {
        return DigestUtils.digestAsHexString(MD5_ALGORITHM_NAME, inputStream);
    }

    @NonNull
    public static StringBuilder appendMd5DigestAsHex(byte[] bytes, StringBuilder builder) {
        return DigestUtils.appendDigestAsHex(MD5_ALGORITHM_NAME, bytes, builder);
    }

    @NonNull
    public static StringBuilder appendMd5DigestAsHex(InputStream inputStream, StringBuilder builder) throws IOException {
        return DigestUtils.appendDigestAsHex(MD5_ALGORITHM_NAME, inputStream, builder);
    }

    private static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("Could not find MessageDigest with algorithm \"" + algorithm + "\"", ex);
        }
    }

    private static byte[] digest(String algorithm, byte[] bytes) {
        return DigestUtils.getDigest(algorithm).digest(bytes);
    }

    private static byte[] digest(@NonNull String algorithm, @NonNull InputStream inputStream) throws IOException {
        int bytesRead;
        MessageDigest messageDigest = DigestUtils.getDigest(algorithm);
        byte[] buffer = new byte[4096];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            messageDigest.update(buffer, 0, bytesRead);
        }
        return messageDigest.digest();
    }

    @NonNull
    private static String digestAsHexString(@NonNull String algorithm, @NonNull byte[] bytes) {
        char[] hexDigest = DigestUtils.digestAsHexChars(algorithm, bytes);
        return new String(hexDigest);
    }

    @NonNull
    private static String digestAsHexString(@NonNull String algorithm, @NonNull InputStream inputStream) throws IOException {
        char[] hexDigest = DigestUtils.digestAsHexChars(algorithm, inputStream);
        return new String(hexDigest);
    }

    @NonNull
    private static StringBuilder appendDigestAsHex(@NonNull String algorithm, @NonNull byte[] bytes, @NonNull StringBuilder builder) {
        char[] hexDigest = DigestUtils.digestAsHexChars(algorithm, bytes);
        return builder.append(hexDigest);
    }

    @NonNull
    private static StringBuilder appendDigestAsHex(@NonNull String algorithm, @NonNull InputStream inputStream, @NonNull StringBuilder builder) throws IOException {
        char[] hexDigest = DigestUtils.digestAsHexChars(algorithm, inputStream);
        return builder.append(hexDigest);
    }

    @NonNull
    private static char[] digestAsHexChars(@NonNull String algorithm, @NonNull byte[] bytes) {
        byte[] digest = DigestUtils.digest(algorithm, bytes);
        return DigestUtils.encodeHex(digest);
    }

    @NonNull
    private static char[] digestAsHexChars(@NonNull String algorithm, @NonNull InputStream inputStream) throws IOException {
        byte[] digest = DigestUtils.digest(algorithm, inputStream);
        return DigestUtils.encodeHex(digest);
    }

    @NonNull
    private static char[] encodeHex(@NonNull byte[] bytes) {
        char[] chars = new char[32];
        for (int i = 0; i < chars.length; i += 2) {
            byte b = bytes[i / 2];
            chars[i] = HEX_CHARS[b >>> 4 & 0xF];
            chars[i + 1] = HEX_CHARS[b & 0xF];
        }
        return chars;
    }
}

