/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils;

import com.aspectran.utils.annotation.jsr305.NonNull;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public class ExceptionUtils {
    @NonNull
    public static Throwable getRootCause(@NonNull Throwable t) {
        while (t.getCause() != null) {
            t = t.getCause();
        }
        return t;
    }

    @NonNull
    public static Exception getRootCauseException(@NonNull Exception e) {
        Throwable cause = ExceptionUtils.getRootCause(e);
        if (cause instanceof Exception) {
            return (Exception)cause;
        }
        return e;
    }

    @NonNull
    public static String getStacktrace(@NonNull Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        return sw.getBuffer().toString().trim();
    }

    @NonNull
    public static String getSimpleMessage(@NonNull Throwable t) {
        return t.getMessage() != null ? t.getMessage() : t.toString();
    }

    @NonNull
    public static String getRootCauseSimpleMessage(@NonNull Throwable t) {
        return ExceptionUtils.getSimpleMessage(ExceptionUtils.getRootCause(t));
    }

    public static Throwable throwIfError(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        return t;
    }

    public static Throwable throwIfRTE(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        return t;
    }

    public static Throwable throwIfIOE(Throwable t) throws IOException {
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        return t;
    }

    public static Throwable throwRootCauseIfIOE(Throwable t) throws IOException {
        return ExceptionUtils.throwIfIOE(ExceptionUtils.getRootCause(t));
    }

    public static IllegalArgumentException throwAsIAE(Throwable t) {
        return ExceptionUtils.throwAsIAE(t, t.getMessage());
    }

    public static IllegalArgumentException throwAsIAE(Throwable t, String msg) {
        ExceptionUtils.throwIfRTE(t);
        ExceptionUtils.throwIfError(t);
        throw new IllegalArgumentException(msg, t);
    }

    public static IllegalArgumentException unwrapAndThrowAsIAE(Throwable t) {
        return ExceptionUtils.throwAsIAE(ExceptionUtils.getRootCause(t));
    }

    public static IllegalArgumentException unwrapAndThrowAsIAE(Throwable t, String msg) {
        throw ExceptionUtils.throwAsIAE(ExceptionUtils.getRootCause(t), msg);
    }
}

