/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils;

import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.wildcard.WildcardMatcher;
import com.aspectran.utils.wildcard.WildcardPattern;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;

public class FileScanner {
    private final String basePath;

    public FileScanner() {
        this(null);
    }

    public FileScanner(String basePath) {
        this.basePath = basePath;
    }

    public Map<String, File> scan(String filePathPattern) {
        LinkedHashMap<String, File> scannedFiles = new LinkedHashMap<String, File>();
        this.scan(filePathPattern, scannedFiles);
        return scannedFiles;
    }

    public void scan(String filePathPattern, @NonNull Map<String, File> scannedFiles) {
        this.scan(filePathPattern, scannedFiles::put);
    }

    public void scan(String filePathPattern, SaveHandler saveHandler) {
        if (filePathPattern == null) {
            throw new IllegalArgumentException("filePathPattern must not be null");
        }
        WildcardPattern pattern = WildcardPattern.compile(filePathPattern, '/');
        WildcardMatcher matcher = new WildcardMatcher(pattern);
        matcher.separate(filePathPattern);
        StringBuilder sb = new StringBuilder();
        while (matcher.hasNext()) {
            String term = matcher.next();
            if (!term.isEmpty()) {
                if (WildcardPattern.hasWildcards(term)) break;
                if (!sb.isEmpty()) {
                    sb.append('/');
                }
                sb.append(term);
                continue;
            }
            sb.append('/');
        }
        String basePath = sb.toString();
        this.scan(basePath, matcher, saveHandler);
    }

    public Map<String, File> scan(String basePath, String filePathPattern) {
        LinkedHashMap<String, File> scannedFiles = new LinkedHashMap<String, File>();
        this.scan(basePath, filePathPattern, scannedFiles);
        return scannedFiles;
    }

    public void scan(String basePath, String filePathPattern, @NonNull Map<String, File> scannedFiles) {
        this.scan(basePath, filePathPattern, scannedFiles::put);
    }

    public void scan(@NonNull String basePath, String filePathPattern, SaveHandler saveHandler) {
        WildcardPattern pattern = WildcardPattern.compile(filePathPattern, '/');
        WildcardMatcher matcher = new WildcardMatcher(pattern);
        if (basePath.charAt(basePath.length() - 1) == '/') {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        this.scan(basePath, matcher, saveHandler);
    }

    protected void scan(String targetPath, WildcardMatcher matcher, SaveHandler saveHandler) {
        File target = StringUtils.hasText(this.basePath) ? new File(this.basePath, targetPath) : new File(targetPath);
        if (!target.exists()) {
            return;
        }
        target.listFiles(file -> {
            String filePath = targetPath + "/" + file.getName();
            if (file.isDirectory()) {
                this.scan(filePath, matcher, saveHandler);
            } else if (matcher.matches(filePath)) {
                saveHandler.save(filePath, file);
            }
            return false;
        });
    }

    public static interface SaveHandler {
        public void save(String var1, File var2);
    }
}

