/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils;

import com.aspectran.utils.Assert;
import com.aspectran.utils.ClassUtils;
import com.aspectran.utils.PathUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;

public abstract class ResourceUtils {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String JAR_URL_PREFIX = "jar:";
    public static final String WAR_URL_PREFIX = "war:";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String URL_PROTOCOL_WAR = "war";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    public static final String URL_PROTOCOL_VFSFILE = "vfsfile";
    public static final String URL_PROTOCOL_VFS = "vfs";
    public static final String JAR_FILE_EXTENSION = ".jar";
    public static final String JAR_URL_SEPARATOR = "!/";
    public static final String WAR_URL_SEPARATOR = "*/";

    public static boolean isUrl(@Nullable String resourceLocation) {
        if (resourceLocation == null) {
            return false;
        }
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            return true;
        }
        try {
            ResourceUtils.toURL(resourceLocation);
            return true;
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    @NonNull
    public static URL getURL(String resourceLocation) throws FileNotFoundException {
        return ResourceUtils.getURL(resourceLocation, ClassUtils.getDefaultClassLoader());
    }

    @NonNull
    public static URL getURL(String resourceLocation, ClassLoader classLoader) throws FileNotFoundException {
        Assert.notNull((Object)resourceLocation, "resourceLocation must not be null");
        Assert.notNull((Object)classLoader, "classLoader must not be null");
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            String path = resourceLocation.substring(CLASSPATH_URL_PREFIX.length());
            URL url = classLoader.getResource(path);
            if (url == null) {
                String description = "class path resource [" + path + "]";
                throw new FileNotFoundException(description + " cannot be resolved to URL because it does not exist");
            }
            return url;
        }
        try {
            return ResourceUtils.toURL(resourceLocation);
        }
        catch (MalformedURLException ex) {
            try {
                return new File(resourceLocation).toURI().toURL();
            }
            catch (MalformedURLException ex2) {
                throw new FileNotFoundException("Resource location [" + resourceLocation + "] is neither a URL not a well-formed file path");
            }
        }
    }

    @NonNull
    public static File getFile(String resourceLocation) throws FileNotFoundException {
        return ResourceUtils.getFile(resourceLocation, null);
    }

    @NonNull
    public static File getFile(String resourceLocation, ClassLoader classLoader) throws FileNotFoundException {
        Assert.notNull((Object)resourceLocation, "resourceLocation must not be null");
        if (resourceLocation.startsWith(CLASSPATH_URL_PREFIX)) {
            String path = resourceLocation.substring(CLASSPATH_URL_PREFIX.length());
            String description = "class path resource [" + path + "]";
            URL url = classLoader != null ? classLoader.getResource(path) : ClassUtils.getDefaultClassLoader().getResource(path);
            if (url == null) {
                throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not exist");
            }
            return ResourceUtils.getFile(url, description);
        }
        try {
            return ResourceUtils.getFile(ResourceUtils.toURL(resourceLocation));
        }
        catch (MalformedURLException ex) {
            return new File(resourceLocation);
        }
    }

    @NonNull
    public static File getFile(URL resourceUrl) throws FileNotFoundException {
        return ResourceUtils.getFile(resourceUrl, "URL");
    }

    @NonNull
    public static File getFile(URL resourceUrl, String description) throws FileNotFoundException {
        Assert.notNull((Object)resourceUrl, "Resource URL must not be null");
        if (!URL_PROTOCOL_FILE.equals(resourceUrl.getProtocol())) {
            throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not reside in the file system: " + resourceUrl);
        }
        try {
            return new File(ResourceUtils.toURI(resourceUrl).getSchemeSpecificPart());
        }
        catch (URISyntaxException ex) {
            return new File(resourceUrl.getFile());
        }
    }

    @NonNull
    public static File getFile(URI resourceUri) throws FileNotFoundException {
        return ResourceUtils.getFile(resourceUri, "URI");
    }

    @NonNull
    public static File getFile(URI resourceUri, String description) throws FileNotFoundException {
        Assert.notNull((Object)resourceUri, "Resource URI must not be null");
        if (!URL_PROTOCOL_FILE.equals(resourceUri.getScheme())) {
            throw new FileNotFoundException(description + " cannot be resolved to absolute file path because it does not reside in the file system: " + resourceUri);
        }
        return new File(resourceUri.getSchemeSpecificPart());
    }

    public static boolean isFileURL(@NonNull URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_FILE.equals(protocol) || URL_PROTOCOL_VFSFILE.equals(protocol) || URL_PROTOCOL_VFS.equals(protocol);
    }

    public static boolean isJarURL(@NonNull URL url) {
        String protocol = url.getProtocol();
        return URL_PROTOCOL_JAR.equals(protocol) || URL_PROTOCOL_WAR.equals(protocol) || URL_PROTOCOL_ZIP.equals(protocol) || URL_PROTOCOL_VFSZIP.equals(protocol) || URL_PROTOCOL_WSJAR.equals(protocol);
    }

    public static boolean isJarFileURL(@NonNull URL url) {
        return URL_PROTOCOL_FILE.equals(url.getProtocol()) && url.getPath().toLowerCase().endsWith(JAR_FILE_EXTENSION);
    }

    @NonNull
    public static URL extractJarFileURL(@NonNull URL jarUrl) throws MalformedURLException {
        String urlFile = jarUrl.getFile();
        int separatorIndex = urlFile.indexOf(JAR_URL_SEPARATOR);
        if (separatorIndex != -1) {
            Object jarFile = urlFile.substring(0, separatorIndex);
            try {
                return ResourceUtils.toURL((String)jarFile);
            }
            catch (MalformedURLException ex) {
                if (!((String)jarFile).startsWith("/")) {
                    jarFile = "/" + (String)jarFile;
                }
                return ResourceUtils.toURL(FILE_URL_PREFIX + (String)jarFile);
            }
        }
        return jarUrl;
    }

    @NonNull
    public static URL extractArchiveURL(@NonNull URL jarUrl) throws MalformedURLException {
        String urlFile = jarUrl.getFile();
        int endIndex = urlFile.indexOf(WAR_URL_SEPARATOR);
        if (endIndex != -1) {
            String warFile = urlFile.substring(0, endIndex);
            if (URL_PROTOCOL_WAR.equals(jarUrl.getProtocol())) {
                return ResourceUtils.toURL(warFile);
            }
            int startIndex = warFile.indexOf(WAR_URL_PREFIX);
            if (startIndex != -1) {
                return ResourceUtils.toURL(warFile.substring(startIndex + WAR_URL_PREFIX.length()));
            }
        }
        return ResourceUtils.extractJarFileURL(jarUrl);
    }

    @NonNull
    public static URI toURI(@NonNull URL url) throws URISyntaxException {
        return ResourceUtils.toURI(url.toString());
    }

    @NonNull
    public static URI toURI(String location) throws URISyntaxException {
        return new URI(StringUtils.replace(location, " ", "%20"));
    }

    @NonNull
    public static URL toURL(String location) throws MalformedURLException {
        try {
            return ResourceUtils.toURI(PathUtils.cleanPath(location)).toURL();
        }
        catch (IllegalArgumentException | URISyntaxException ex) {
            return new URL(location);
        }
    }

    @NonNull
    public static URL getResource(String resource) throws IOException {
        return ResourceUtils.getResource(resource, null);
    }

    @NonNull
    public static URL getResource(String resource, ClassLoader classLoader) throws IOException {
        URL url = classLoader != null ? classLoader.getResource(resource) : ClassUtils.getDefaultClassLoader().getResource(resource);
        if (url == null) {
            url = ClassUtils.class.getResource(resource);
        }
        if (url == null) {
            throw new IOException("Could not find resource '" + resource + "'");
        }
        return url;
    }

    @NonNull
    public static File getResourceAsFile(String resource) throws IOException {
        return ResourceUtils.getFile(ResourceUtils.getResource(resource));
    }

    @NonNull
    public static File getResourceAsFile(String resource, ClassLoader classLoader) throws IOException {
        return ResourceUtils.getFile(ResourceUtils.getResource(resource, classLoader));
    }

    @NonNull
    public static InputStream getResourceAsStream(String resource) throws IOException {
        return ResourceUtils.getResourceAsStream(resource, null);
    }

    @NonNull
    public static InputStream getResourceAsStream(String resource, ClassLoader classLoader) throws IOException {
        InputStream stream = classLoader != null ? classLoader.getResourceAsStream(resource) : ClassUtils.getDefaultClassLoader().getResourceAsStream(resource);
        if (stream == null) {
            stream = ClassUtils.class.getResourceAsStream(resource);
        }
        if (stream == null) {
            throw new IOException("Could not find resource " + resource);
        }
        return stream;
    }

    @NonNull
    public static Reader getResourceAsReader(String resource) throws IOException {
        return new InputStreamReader(ResourceUtils.getResourceAsStream(resource, null));
    }

    @NonNull
    public static Reader getResourceAsReader(String resource, ClassLoader classLoader) throws IOException {
        return new InputStreamReader(ResourceUtils.getResourceAsStream(resource, classLoader));
    }

    @NonNull
    public static Reader getReader(File file, String encoding) throws IOException {
        Assert.notNull((Object)file, "Resource file must not be null");
        FileInputStream stream = new FileInputStream(file);
        InputStreamReader reader = encoding != null ? new InputStreamReader((InputStream)stream, encoding) : new InputStreamReader(stream);
        return reader;
    }

    @NonNull
    public static Reader getReader(URL url, String encoding) throws IOException {
        Assert.notNull((Object)url, "Resource URL must not be null");
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        InputStream stream = connection.getInputStream();
        InputStreamReader reader = encoding != null ? new InputStreamReader(stream, encoding) : new InputStreamReader(stream);
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(File file, String encoding) throws IOException {
        String source;
        try (Reader reader = ResourceUtils.getReader(file, encoding);){
            source = ResourceUtils.read(reader);
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(URL url, String encoding) throws IOException {
        String source;
        try (Reader reader = ResourceUtils.getReader(url, encoding);){
            source = ResourceUtils.read(reader);
        }
        return source;
    }

    @NonNull
    public static String read(@NonNull Reader reader) throws IOException {
        int len;
        char[] buffer = new char[1024];
        StringBuilder sb = new StringBuilder();
        while ((len = reader.read(buffer)) != -1) {
            sb.append(buffer, 0, len);
        }
        return sb.toString();
    }
}

