/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils;

import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;

public abstract class SystemUtils {
    private static final Logger logger = LoggerFactory.getLogger(SystemUtils.class);
    private static final String JAVA_IO_TMPDIR_PROPERTY = "java.io.tmpdir";
    private static final String USER_HOME_PROPERTY = "user.home";
    private static final String USER_DIR_PROPERTY = "user.dir";

    @Nullable
    public static String getProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Caught AccessControlException when accessing system property [%s]; its value will be returned [null]. Reason: %s", key, ex.getMessage()));
            }
            return null;
        }
    }

    public static String getProperty(String name, String defVal) {
        String val = SystemUtils.getProperty(name);
        return val != null ? val : defVal;
    }

    @Nullable
    public static String clearProperty(String key) {
        try {
            return System.clearProperty(key);
        }
        catch (Exception ex) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Caught AccessControlException when accessing system property [%s]. Reason: %s", key, ex.getMessage()));
            }
            return null;
        }
    }

    public static String getJavaIoTmpDir() {
        return SystemUtils.getProperty(JAVA_IO_TMPDIR_PROPERTY);
    }

    public static String getUserHome() {
        return SystemUtils.getProperty(USER_HOME_PROPERTY);
    }

    public static String getUserDir() {
        return SystemUtils.getProperty(USER_DIR_PROPERTY);
    }
}

