/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils;

import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.apon.Parameter;
import com.aspectran.utils.apon.ParameterValue;
import com.aspectran.utils.apon.Parameters;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;

public class ToStringBuilder {
    private final StringBuilder buffer;
    private final int start;

    public ToStringBuilder() {
        this(null);
    }

    public ToStringBuilder(String name) {
        this(name, 64);
    }

    public ToStringBuilder(int capacity) {
        this(null, capacity);
    }

    public ToStringBuilder(String name, int capacity) {
        this.buffer = new StringBuilder(capacity);
        if (name != null) {
            this.buffer.append(name).append(" ");
            this.start = this.buffer.length() + 1;
        } else {
            this.start = 1;
        }
        this.buffer.append("{");
    }

    public ToStringBuilder(String name, Parameters parameters) {
        this(name, 128);
        if (parameters != null) {
            this.append(parameters);
        }
    }

    public ToStringBuilder append(String name, Object value) {
        if (value != null) {
            this.appendName(name);
            this.append(value);
        }
        return this;
    }

    public ToStringBuilder append(String name, Class<?> clazz) {
        if (clazz != null) {
            this.appendName(name);
            this.append(clazz.getTypeName());
        }
        return this;
    }

    public ToStringBuilder append(String name, Method method) {
        if (method != null) {
            this.appendName(name);
            this.append(method);
        }
        return this;
    }

    public ToStringBuilder appendForce(String name, Object value) {
        this.appendName(name);
        this.append(value);
        return this;
    }

    public ToStringBuilder append(String name, boolean value) {
        if (value) {
            this.appendName(name);
            this.buffer.append(true);
        }
        return this;
    }

    public ToStringBuilder appendForce(String name, boolean value) {
        this.appendName(name);
        this.buffer.append(value);
        return this;
    }

    public ToStringBuilder appendEqual(String name, Object value, Object compare) {
        if (value != null && value.equals(compare)) {
            this.appendName(name);
            this.append(value);
        }
        return this;
    }

    public ToStringBuilder appendNotEqual(String name, Object value, Object compare) {
        if (value != null && !value.equals(compare)) {
            this.appendName(name);
            this.append(value);
        }
        return this;
    }

    public ToStringBuilder appendSize(String name, Object object) {
        if (object != null) {
            this.appendName(name);
            if (object instanceof Map) {
                Map map = (Map)object;
                this.buffer.append(map.size());
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                this.buffer.append(collection.size());
            } else if (object.getClass().isArray()) {
                this.buffer.append(Array.getLength(object));
            } else if (object instanceof CharSequence) {
                CharSequence charSequence = (CharSequence)object;
                this.buffer.append(charSequence.length());
            }
        }
        return this;
    }

    private void appendName(Object name) {
        this.appendName(name, this.start);
    }

    private void appendName(Object name, int start) {
        if (this.buffer.length() > start) {
            this.appendComma();
        }
        this.buffer.append(name).append("=");
    }

    private void appendComma() {
        this.buffer.append(", ");
    }

    private void append(Object object) {
        if (object == null) {
            this.buffer.append((Object)null);
        } else if (object instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)object;
            this.buffer.append(charSequence);
        } else if (object instanceof Map) {
            Map map = (Map)object;
            this.append(map);
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            this.append(collection);
        } else if (object instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)object;
            this.append(enumeration);
        } else if (object.getClass().isArray()) {
            this.buffer.append("[");
            int len = Array.getLength(object);
            for (int i = 0; i < len; ++i) {
                Object value = Array.get(object, i);
                this.checkCircularReference(object, value);
                if (i > 0) {
                    this.appendComma();
                }
                this.append(value);
            }
            this.buffer.append("]");
        } else if (object instanceof Parameters) {
            Parameters parameters = (Parameters)object;
            this.buffer.append("{");
            this.append(parameters);
            this.buffer.append("}");
        } else if (object instanceof ToStringBuilder) {
            ToStringBuilder toStringBuilder = (ToStringBuilder)object;
            this.buffer.append((CharSequence)toStringBuilder.getBuffer());
        } else {
            this.buffer.append(object);
        }
    }

    private void append(@NonNull Map<?, ?> map) {
        this.buffer.append("{");
        int len = this.buffer.length();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            this.appendName(key, len);
            this.append(value);
        }
        this.buffer.append("}");
    }

    private void append(@NonNull Collection<?> list) {
        this.buffer.append("[");
        int len = this.buffer.length();
        for (Object o : list) {
            if (this.buffer.length() > len) {
                this.appendComma();
            }
            this.append(o);
        }
        this.buffer.append("]");
    }

    private void append(@NonNull Enumeration<?> en) {
        this.buffer.append("[");
        while (en.hasMoreElements()) {
            this.append(en.nextElement());
            if (!en.hasMoreElements()) continue;
            this.appendComma();
        }
        this.buffer.append("]");
    }

    private void append(@NonNull Parameters parameters) {
        int len = this.buffer.length();
        Map<String, ParameterValue> params = parameters.getParameterValueMap();
        for (Parameter parameter : params.values()) {
            String name = parameter.getName();
            Object value = parameter.getValue();
            if (value == null) continue;
            this.appendName(name, len);
            this.append(value);
        }
    }

    private void append(@NonNull Method method) {
        this.buffer.append(method.getDeclaringClass().getTypeName());
        this.buffer.append('.');
        this.buffer.append(method.getName());
        this.buffer.append('(');
        Class<?>[] types = method.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                this.appendComma();
            }
            this.append(types[i].getTypeName());
        }
        this.buffer.append(')');
    }

    public String toString() {
        this.buffer.append("}");
        return this.buffer.toString();
    }

    public static String toString(Parameters parameters) {
        return ToStringBuilder.toString(null, parameters);
    }

    public static String toString(String name, Parameters parameters) {
        return new ToStringBuilder(name, parameters).toString();
    }

    protected StringBuilder getBuffer() {
        return this.buffer;
    }

    private void checkCircularReference(@NonNull Object wrapper, Object member) {
        if (wrapper.equals(member)) {
            throw new IllegalArgumentException("Serialization Failure: A circular reference was detected while converting a member object [" + member + "] in [" + wrapper + "]");
        }
    }
}

