/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils;

import com.aspectran.utils.annotation.jsr305.NonNull;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public abstract class TypeUtils {
    private static final Map<Class<?>, Class<?>> primitiveWrapperTypeMap = new HashMap(32);
    private static final Map<Class<?>, Class<?>> primitiveTypeToWrapperMap = new HashMap(32);

    public static boolean isPrimitiveWrapper(Class<?> clazz) {
        return primitiveWrapperTypeMap.containsKey(clazz);
    }

    public static boolean isPrimitiveArray(@NonNull Class<?> clazz) {
        return clazz.isArray() && clazz.getComponentType().isPrimitive();
    }

    public static boolean isPrimitiveWrapperArray(@NonNull Class<?> clazz) {
        return clazz.isArray() && TypeUtils.isPrimitiveWrapper(clazz.getComponentType());
    }

    public static boolean isAssignable(Class<?> lhsType, Class<?> rhsType) {
        if (rhsType == null) {
            return !lhsType.isPrimitive();
        }
        if (lhsType.isArray() || rhsType.isArray()) {
            if (lhsType.isArray() && rhsType.isArray()) {
                return TypeUtils.isAssignable(lhsType.getComponentType(), rhsType.getComponentType());
            }
        } else {
            if (lhsType.isAssignableFrom(rhsType)) {
                return true;
            }
            if (rhsType.isPrimitive() && !lhsType.isPrimitive() && lhsType.equals(TypeUtils.getPrimitiveWrapper(rhsType))) {
                return true;
            }
            if (lhsType.isPrimitive() && !rhsType.isPrimitive() && rhsType.equals(TypeUtils.getPrimitiveWrapper(lhsType))) {
                return true;
            }
        }
        return false;
    }

    public static boolean isAssignableValue(Class<?> type, Object value) {
        if (value == null) {
            return !type.isPrimitive();
        }
        Class<?> valueType = value.getClass();
        if (type.isArray() || valueType.isArray()) {
            if (type.isArray() && valueType.isArray()) {
                int len = Array.getLength(value);
                if (len == 0) {
                    return true;
                }
                Object first = Array.get(value, 0);
                return TypeUtils.isAssignableValue(type.getComponentType(), first);
            }
        } else {
            if (type.isInstance(value)) {
                return true;
            }
            if (valueType.isPrimitive() && !type.isPrimitive() && type.equals(TypeUtils.getPrimitiveWrapper(valueType))) {
                return true;
            }
            if (type.isPrimitive() && !valueType.isPrimitive() && valueType.equals(TypeUtils.getPrimitiveWrapper(type))) {
                return true;
            }
        }
        return false;
    }

    public static Class<?> getPrimitiveWrapper(Class<?> primitiveType) {
        return primitiveTypeToWrapperMap.get(primitiveType);
    }

    public static Class<?> wrapperToPrimitive(Class<?> cls) {
        return primitiveWrapperTypeMap.get(cls);
    }

    public static Class<?>[] wrappersToPrimitives(Class<?>[] classes) {
        if (classes == null) {
            return null;
        }
        if (classes.length == 0) {
            return classes;
        }
        Class[] convertedClasses = new Class[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            convertedClasses[i] = TypeUtils.wrapperToPrimitive(classes[i]);
        }
        return convertedClasses;
    }

    static {
        primitiveWrapperTypeMap.put(Boolean.class, Boolean.TYPE);
        primitiveWrapperTypeMap.put(Byte.class, Byte.TYPE);
        primitiveWrapperTypeMap.put(Character.class, Character.TYPE);
        primitiveWrapperTypeMap.put(Short.class, Short.TYPE);
        primitiveWrapperTypeMap.put(Integer.class, Integer.TYPE);
        primitiveWrapperTypeMap.put(Long.class, Long.TYPE);
        primitiveWrapperTypeMap.put(Float.class, Float.TYPE);
        primitiveWrapperTypeMap.put(Double.class, Double.TYPE);
        primitiveWrapperTypeMap.put(Boolean[].class, boolean[].class);
        primitiveWrapperTypeMap.put(Byte[].class, byte[].class);
        primitiveWrapperTypeMap.put(Character[].class, char[].class);
        primitiveWrapperTypeMap.put(Short[].class, short[].class);
        primitiveWrapperTypeMap.put(Integer[].class, int[].class);
        primitiveWrapperTypeMap.put(Long[].class, long[].class);
        primitiveWrapperTypeMap.put(Float[].class, float[].class);
        primitiveWrapperTypeMap.put(Double[].class, double[].class);
        primitiveWrapperTypeMap.put(Void.TYPE, Void.TYPE);
        for (Map.Entry<Class<?>, Class<?>> e : primitiveWrapperTypeMap.entrySet()) {
            primitiveTypeToWrapperMap.put(e.getValue(), e.getKey());
        }
    }
}

