/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils.apon;

import com.aspectran.utils.ClassUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.apon.ArrayParameters;
import com.aspectran.utils.apon.Parameter;
import com.aspectran.utils.apon.Parameters;
import com.aspectran.utils.apon.ValueType;
import com.aspectran.utils.apon.VariableParameters;
import com.aspectran.utils.json.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public abstract class JsonToApon {
    @NonNull
    public static Parameters from(String json) throws IOException {
        return JsonToApon.from(json, new VariableParameters());
    }

    @NonNull
    public static <T extends Parameters> T from(String json, Class<T> requiredType) throws IOException {
        Parameters container = (Parameters)ClassUtils.createInstance(requiredType);
        JsonToApon.from(json, container);
        return (T)container;
    }

    @NonNull
    public static <T extends Parameters> T from(String json, T container) throws IOException {
        if (json == null) {
            throw new IllegalArgumentException("json must not be null");
        }
        return JsonToApon.from((Reader)new StringReader(json), container);
    }

    @NonNull
    public static Parameters from(Reader reader) throws IOException {
        return JsonToApon.from(reader, new VariableParameters());
    }

    @NonNull
    public static <T extends Parameters> T from(Reader reader, Class<T> requiredType) throws IOException {
        Parameters container = (Parameters)ClassUtils.createInstance(requiredType);
        JsonToApon.from(reader, container);
        return (T)container;
    }

    @NonNull
    public static <T extends Parameters> T from(Reader reader, T container) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException("reader must not be null");
        }
        if (container == null) {
            throw new IllegalArgumentException("container must not be null");
        }
        try {
            JsonReader jsonReader = new JsonReader(reader);
            String name = container instanceof ArrayParameters ? "<noname>" : null;
            JsonToApon.read(jsonReader, container, name);
        }
        catch (Exception e) {
            throw new IOException("Failed to convert JSON to APON", e);
        }
        return container;
    }

    private static void read(@NonNull JsonReader reader, Parameters container, String name) throws IOException {
        switch (reader.peek()) {
            case BEGIN_OBJECT: {
                reader.beginObject();
                if (name != null) {
                    container = container.newParameters(name);
                }
                while (reader.hasNext()) {
                    JsonToApon.read(reader, container, reader.nextName());
                }
                reader.endObject();
                return;
            }
            case BEGIN_ARRAY: {
                reader.beginArray();
                while (reader.hasNext()) {
                    JsonToApon.read(reader, container, name);
                }
                reader.endArray();
                return;
            }
            case STRING: {
                container.putValue(name, (Object)reader.nextString());
                return;
            }
            case BOOLEAN: {
                container.putValue(name, (Object)reader.nextBoolean());
                return;
            }
            case NUMBER: {
                try {
                    container.putValue(name, (Object)reader.nextInt());
                }
                catch (NumberFormatException e0) {
                    try {
                        container.putValue(name, (Object)reader.nextLong());
                    }
                    catch (NumberFormatException e1) {
                        container.putValue(name, (Object)reader.nextDouble());
                    }
                }
                return;
            }
            case NULL: {
                reader.nextNull();
                Parameter parameter = container.getParameter(name);
                if (parameter == null || parameter.getValueType() != ValueType.PARAMETERS) {
                    container.putValue(name, null);
                }
                return;
            }
        }
        throw new IllegalStateException();
    }
}

