/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils.json;

import com.aspectran.utils.ArrayStack;
import com.aspectran.utils.BeanUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.apon.Parameter;
import com.aspectran.utils.apon.ParameterValue;
import com.aspectran.utils.apon.Parameters;
import com.aspectran.utils.json.JsonString;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class JsonWriter {
    private static final String DEFAULT_INDENT_STRING = "  ";
    private static final String NULL_STRING = "null";
    private final ArrayStack<Boolean> writtenFlags = new ArrayStack();
    private final Writer out;
    private boolean prettyPrint;
    private String indentString;
    private String dateFormat;
    private String dateTimeFormat;
    private boolean nullWritable = true;
    private int indentDepth;
    private String pendedName;
    private Object upperObject;

    public JsonWriter() {
        this(new StringWriter());
    }

    public JsonWriter(Writer out) {
        this.out = out;
        this.setIndentString(DEFAULT_INDENT_STRING);
        this.writtenFlags.push(false);
    }

    private void setIndentString(String indentString) {
        this.prettyPrint = indentString != null;
        this.indentString = indentString;
    }

    public <T extends JsonWriter> T prettyPrint(boolean prettyPrint) {
        if (prettyPrint) {
            this.setIndentString(DEFAULT_INDENT_STRING);
        } else {
            this.setIndentString(null);
        }
        return (T)this;
    }

    public <T extends JsonWriter> T indentString(String indentString) {
        this.setIndentString(indentString);
        return (T)this;
    }

    public <T extends JsonWriter> T dateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        return (T)this;
    }

    public <T extends JsonWriter> T dateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
        return (T)this;
    }

    public <T extends JsonWriter> T nullWritable(boolean nullWritable) {
        this.nullWritable = nullWritable;
        return (T)this;
    }

    public <T extends JsonWriter> T write(Object object) throws IOException {
        if (object == null) {
            this.writeNull();
        } else if (object instanceof String) {
            this.writeValue(object.toString());
        } else if (object instanceof JsonString) {
            this.writeJson(object.toString());
        } else if (object instanceof Character) {
            this.writeValue(String.valueOf(((Character)object).charValue()));
        } else if (object instanceof Boolean) {
            this.writeValue((Boolean)object);
        } else if (object instanceof Number) {
            this.writeValue((Number)object);
        } else if (object instanceof Parameters) {
            this.beginObject();
            Map<String, ParameterValue> params = ((Parameters)object).getParameterValueMap();
            for (Parameter parameter : params.values()) {
                String name = parameter.getName();
                Object value = parameter.getValue();
                this.writeName(name);
                this.write(object, value);
            }
            this.endObject();
        } else if (object instanceof Map) {
            this.beginObject();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                String string = entry.getKey().toString();
                Object value = entry.getValue();
                this.writeName(string);
                this.write(object, value);
            }
            this.endObject();
        } else if (object instanceof Collection) {
            this.beginArray();
            for (Object value : (Collection)object) {
                if (value != null) {
                    this.write(object, value);
                    continue;
                }
                this.writeNull(true);
            }
            this.endArray();
        } else if (object.getClass().isArray()) {
            this.beginArray();
            int len = Array.getLength(object);
            for (int i = 0; i < len; ++i) {
                Object object2 = Array.get(object, i);
                if (object2 != null) {
                    this.write(object, object2);
                    continue;
                }
                this.writeNull(true);
            }
            this.endArray();
        } else if (object instanceof Date) {
            if (this.dateTimeFormat != null) {
                SimpleDateFormat dt = new SimpleDateFormat(this.dateTimeFormat);
                this.writeValue(dt.format((Date)object));
            } else {
                this.writeValue(object.toString());
            }
        } else if (object instanceof LocalDate) {
            if (this.dateFormat != null) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.dateFormat);
                this.writeValue(((LocalDate)object).format(formatter));
            } else {
                this.writeValue(object.toString());
            }
        } else if (object instanceof LocalDateTime) {
            if (this.dateTimeFormat != null) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(this.dateTimeFormat);
                this.writeValue(((LocalDateTime)object).format(formatter));
            } else {
                this.writeValue(object.toString());
            }
        } else {
            String[] readablePropertyNames = BeanUtils.getReadablePropertyNamesWithoutNonSerializable(object);
            if (readablePropertyNames != null && readablePropertyNames.length > 0) {
                this.beginObject();
                for (String propertyName : readablePropertyNames) {
                    Object value;
                    try {
                        value = BeanUtils.getProperty(object, propertyName);
                    }
                    catch (InvocationTargetException e) {
                        throw new IOException(e);
                    }
                    this.writeName(propertyName);
                    this.write(object, value);
                }
                this.endObject();
            } else {
                this.writeValue(object.toString());
            }
        }
        return (T)this;
    }

    private void write(Object object, Object member) throws IOException {
        this.checkCircularReference(object, member);
        this.upperObject = object;
        this.write(member);
        this.upperObject = null;
    }

    public JsonWriter writeName(String name) {
        this.pendedName = name;
        return this;
    }

    private void writePendedName() throws IOException {
        if (this.writtenFlags.peek().booleanValue()) {
            this.writeComma();
        }
        if (this.pendedName != null) {
            this.indent();
            this.out.write(JsonWriter.escape(this.pendedName));
            this.out.write(":");
            if (this.prettyPrint) {
                this.out.write(" ");
            }
            this.pendedName = null;
        } else {
            this.indent();
        }
    }

    private void clearPendedName() {
        this.pendedName = null;
    }

    public void writeValue(String value) throws IOException {
        if (this.nullWritable || value != null) {
            this.writePendedName();
            this.out.write(JsonWriter.escape(value));
            this.writtenFlags.update(true);
        } else {
            this.clearPendedName();
        }
    }

    public void writeValue(Boolean value) throws IOException {
        if (this.nullWritable || value != null) {
            this.writePendedName();
            this.out.write(value.toString());
            this.writtenFlags.update(true);
        } else {
            this.clearPendedName();
        }
    }

    public void writeValue(Number value) throws IOException {
        if (this.nullWritable || value != null) {
            this.writePendedName();
            this.out.write(value.toString());
            this.writtenFlags.update(true);
        } else {
            this.clearPendedName();
        }
    }

    public void writeNull() throws IOException {
        this.writeNull(false);
    }

    public void writeNull(boolean force) throws IOException {
        if (this.nullWritable || force) {
            this.writePendedName();
            this.out.write(NULL_STRING);
            this.writtenFlags.update(true);
        } else {
            this.clearPendedName();
        }
    }

    public void writeJson(String json) throws IOException {
        if (this.nullWritable || json != null) {
            this.writePendedName();
            if (json != null) {
                String line;
                BufferedReader reader = new BufferedReader(new StringReader(json));
                boolean first = true;
                while ((line = reader.readLine()) != null) {
                    if (!first) {
                        this.nextLine();
                        this.indent();
                    }
                    this.out.write(line);
                    first = false;
                }
            } else {
                this.out.write(NULL_STRING);
            }
            this.writtenFlags.update(true);
        } else {
            this.clearPendedName();
        }
    }

    private void writeComma() throws IOException {
        this.out.write(",");
        this.nextLine();
    }

    public void beginObject() throws IOException {
        this.writePendedName();
        this.out.write("{");
        this.nextLine();
        ++this.indentDepth;
        this.writtenFlags.push(false);
    }

    public void endObject() throws IOException {
        --this.indentDepth;
        if (this.writtenFlags.pop().booleanValue()) {
            this.nextLine();
        }
        this.indent();
        this.out.write("}");
        this.writtenFlags.update(true);
    }

    public void beginArray() throws IOException {
        this.writePendedName();
        this.out.write("[");
        this.nextLine();
        ++this.indentDepth;
        this.writtenFlags.push(false);
    }

    public void endArray() throws IOException {
        --this.indentDepth;
        if (this.writtenFlags.pop().booleanValue()) {
            this.nextLine();
        }
        this.indent();
        this.out.write("]");
        this.writtenFlags.update(true);
    }

    private void indent() throws IOException {
        if (this.prettyPrint) {
            for (int i = 0; i < this.indentDepth; ++i) {
                this.out.write(this.indentString);
            }
        }
    }

    private void nextLine() throws IOException {
        if (this.prettyPrint) {
            this.out.write("\n");
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public String toString() {
        return this.out.toString();
    }

    private void checkCircularReference(Object object, Object member) throws IOException {
        if (object == member || this.upperObject != null && this.upperObject == member) {
            Object what = this.pendedName != null ? "member '" + this.pendedName + "'" : "a member";
            throw new IOException("JSON Serialization Failure: A circular reference was detected while converting " + (String)what);
        }
    }

    @NonNull
    private static String escape(String string) {
        if (string == null || string.isEmpty()) {
            return "\"\"";
        }
        int len = string.length();
        char c = '\u0000';
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }
}

