/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils.security;

import com.aspectran.utils.PBEncryptionUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.apon.AponReader;
import com.aspectran.utils.apon.Parameters;
import com.aspectran.utils.apon.VariableParameters;
import com.aspectran.utils.security.ExpiredPBTokenException;
import com.aspectran.utils.security.InvalidPBTokenException;
import com.aspectran.utils.security.PBTokenIssuer;

public class TimeLimitedPBTokenIssuer
extends PBTokenIssuer {
    private static final String TOKEN_SEPARATOR = "_";
    private static final Parameters EMPTY_PAYLOAD = new VariableParameters();
    private static final int DIGIT_RADIX = 36;
    private static final long DEFAULT_EXPIRATION_TIME = 30000L;
    private final long expirationTime;

    public TimeLimitedPBTokenIssuer() {
        this(30000L);
    }

    public TimeLimitedPBTokenIssuer(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public String createToken() {
        return this.createToken(EMPTY_PAYLOAD);
    }

    @Override
    public String createToken(Parameters payload) {
        if (payload == null) {
            throw new IllegalArgumentException("payload must not be null");
        }
        long time = System.currentTimeMillis() + this.expirationTime;
        String combined = Long.toString(time, 36) + TOKEN_SEPARATOR + payload;
        return PBEncryptionUtils.encrypt(combined);
    }

    @Override
    public <T extends Parameters> T parseToken(String token) throws InvalidPBTokenException {
        return this.parseToken(token, null);
    }

    @Override
    public <T extends Parameters> T parseToken(String token, @Nullable Class<T> payloadType) throws InvalidPBTokenException {
        String payload;
        long time;
        if (StringUtils.isEmpty(token)) {
            throw new IllegalArgumentException("token must not be null or empty");
        }
        try {
            String combined = PBEncryptionUtils.decrypt(token);
            int index = combined.indexOf(TOKEN_SEPARATOR);
            if (index == -1) {
                throw new InvalidPBTokenException(token);
            }
            time = Long.parseLong(combined.substring(0, index), 36);
            payload = combined.substring(index + 1);
        }
        catch (Exception e) {
            throw new InvalidPBTokenException(token, e);
        }
        if (time < System.currentTimeMillis()) {
            throw new ExpiredPBTokenException(token);
        }
        try {
            if (payloadType != null) {
                return (T)AponReader.parse(payload, payloadType);
            }
            return (T)AponReader.parse(payload);
        }
        catch (Exception e) {
            throw new InvalidPBTokenException(token, e);
        }
    }

    public static String getToken() {
        TimeLimitedPBTokenIssuer tokenIssuer = new TimeLimitedPBTokenIssuer();
        return tokenIssuer.createToken();
    }

    public static String getToken(long expirationTime) {
        TimeLimitedPBTokenIssuer tokenIssuer = new TimeLimitedPBTokenIssuer(expirationTime);
        return tokenIssuer.createToken();
    }

    public static String getToken(Parameters payload) {
        TimeLimitedPBTokenIssuer tokenIssuer = new TimeLimitedPBTokenIssuer();
        return tokenIssuer.createToken(payload);
    }

    public static String getToken(Parameters payload, long expirationTime) {
        TimeLimitedPBTokenIssuer tokenIssuer = new TimeLimitedPBTokenIssuer(expirationTime);
        return tokenIssuer.createToken(payload);
    }

    public static <T extends Parameters> T getPayload(String token) throws InvalidPBTokenException {
        return TimeLimitedPBTokenIssuer.getPayload(token, null);
    }

    public static <T extends Parameters> T getPayload(String token, Class<T> payloadType) throws InvalidPBTokenException {
        TimeLimitedPBTokenIssuer tokenIssuer = new TimeLimitedPBTokenIssuer(0L);
        return tokenIssuer.parseToken(token, payloadType);
    }

    public static void validate(String token) throws InvalidPBTokenException {
        TimeLimitedPBTokenIssuer tokenIssuer = new TimeLimitedPBTokenIssuer(0L);
        tokenIssuer.parseToken(token, null);
    }
}

