/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.activity;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.ActivityPrepareException;
import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.activity.AdapterException;
import com.aspectran.core.activity.CoreActivity;
import com.aspectran.core.activity.TransletNotFoundException;
import com.aspectran.core.activity.request.RequestParseException;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.adapter.SessionAdapter;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.support.i18n.locale.LocaleChangeInterceptor;
import com.aspectran.core.support.i18n.locale.LocaleResolver;
import com.aspectran.core.util.StringUtils;
import com.aspectran.web.activity.request.MultipartFormDataParser;
import com.aspectran.web.activity.request.MultipartRequestParseException;
import com.aspectran.web.activity.request.WebRequestBodyParser;
import com.aspectran.web.adapter.HttpServletRequestAdapter;
import com.aspectran.web.adapter.HttpServletResponseAdapter;
import com.aspectran.web.adapter.HttpSessionAdapter;
import com.aspectran.web.support.http.MediaType;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebActivity
extends CoreActivity {
    private static final String MULTIPART_FORM_DATA_PARSER_SETTING_NAME = "multipartFormDataParser";
    private static final String MAX_REQUEST_SIZE_SETTING_NAME = "maxRequestSize";
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public WebActivity(ActivityContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context);
        this.request = request;
        this.response = response;
    }

    public void prepare(String transletName, MethodType requestMethod) throws TransletNotFoundException, ActivityPrepareException {
        MethodType hiddenRequestMethod;
        String method;
        if (requestMethod == MethodType.POST && (method = this.request.getHeader("X-Method-Override")) != null && (hiddenRequestMethod = MethodType.resolve((String)method)) != null) {
            requestMethod = hiddenRequestMethod;
        }
        super.prepare(transletName, requestMethod);
    }

    protected void adapt() throws AdapterException {
        try {
            String responseEncoding;
            HttpSessionAdapter sessionAdapter = new HttpSessionAdapter(this.request);
            this.setSessionAdapter((SessionAdapter)sessionAdapter);
            HttpServletRequestAdapter requestAdapter = new HttpServletRequestAdapter(this.getTranslet().getRequestMethod(), this.request);
            if (this.getParentActivity() == null) {
                String requestEncoding;
                long maxRequestSize;
                String maxRequestSizeSetting = (String)this.getSetting(MAX_REQUEST_SIZE_SETTING_NAME);
                if (!StringUtils.isEmpty((String)maxRequestSizeSetting) && (maxRequestSize = Long.parseLong(maxRequestSizeSetting)) >= 0L) {
                    requestAdapter.setMaxRequestSize(maxRequestSize);
                }
                if ((requestEncoding = this.getIntendedRequestEncoding()) != null) {
                    try {
                        requestAdapter.setEncoding(requestEncoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RequestParseException("Unable to set request encoding to " + requestEncoding, (Throwable)e);
                    }
                }
            }
            this.setRequestAdapter((RequestAdapter)requestAdapter);
            HttpServletResponseAdapter responseAdapter = new HttpServletResponseAdapter(this.response, (Activity)this);
            if (this.getParentActivity() == null && (responseEncoding = this.getIntendedResponseEncoding()) != null) {
                responseAdapter.setEncoding(responseEncoding);
            }
            this.setResponseAdapter((ResponseAdapter)responseAdapter);
        }
        catch (Exception e) {
            throw new AdapterException("Failed to adapt for Web Activity", (Throwable)e);
        }
        super.adapt();
    }

    protected void parseRequest() throws ActivityTerminatedException, RequestParseException {
        if (this.getParentActivity() == null) {
            ((HttpServletRequestAdapter)this.getRequestAdapter()).preparse();
        } else {
            ((HttpServletRequestAdapter)this.getRequestAdapter()).preparse((HttpServletRequestAdapter)this.getParentActivity().getRequestAdapter());
        }
        MediaType mediaType = ((HttpServletRequestAdapter)this.getRequestAdapter()).getMediaType();
        if (mediaType != null) {
            if (WebRequestBodyParser.isMultipartForm(this.getRequestAdapter().getRequestMethod(), mediaType)) {
                this.parseMultipartFormData();
            } else if (WebRequestBodyParser.isURLEncodedForm(mediaType)) {
                this.parseURLEncodedFormData();
            }
        }
        super.parseRequest();
    }

    private void parseMultipartFormData() throws MultipartRequestParseException {
        String multipartFormDataParser = (String)this.getSetting(MULTIPART_FORM_DATA_PARSER_SETTING_NAME);
        if (multipartFormDataParser == null) {
            throw new MultipartRequestParseException("The setting name 'multipartFormDataParser' for multipart form data parsing is not specified. Please specify 'multipartFormDataParser' via Aspect so that Translet can parse multipart form data.");
        }
        MultipartFormDataParser parser = (MultipartFormDataParser)this.getBean(multipartFormDataParser);
        if (parser == null) {
            throw new MultipartRequestParseException("No bean named '" + multipartFormDataParser + "' is defined");
        }
        parser.parse(this.getRequestAdapter());
    }

    private void parseURLEncodedFormData() throws RequestParseException {
        WebRequestBodyParser.parseURLEncodedFormData(this.getRequestAdapter());
    }

    protected LocaleResolver resolveLocale() {
        String localeChangeInterceptorId;
        LocaleResolver localeResolver = super.resolveLocale();
        if (localeResolver != null && (localeChangeInterceptorId = (String)this.getSetting("localeChangeInterceptor")) != null) {
            LocaleChangeInterceptor localeChangeInterceptor = (LocaleChangeInterceptor)this.getBean(LocaleChangeInterceptor.class, localeChangeInterceptorId);
            localeChangeInterceptor.handle(this.getTranslet(), localeResolver);
        }
        return localeResolver;
    }
}

