/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.activity.request;

import com.aspectran.core.lang.NonNull;
import com.aspectran.core.lang.Nullable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class RequestAttributeMap
implements Map<String, Object> {
    private final HttpServletRequest request;

    public RequestAttributeMap(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public int size() {
        return Collections.list(this.request.getAttributeNames()).size();
    }

    @Override
    public boolean isEmpty() {
        return !this.request.getAttributeNames().hasMoreElements();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.request.getAttribute((String)key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        Enumeration names = this.request.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object object = this.request.getAttribute(name);
            if (!Objects.equals(value, object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        return this.request.getAttribute((String)key);
    }

    @Override
    public Object put(String name, Object value) {
        Object old = this.request.getAttribute(name);
        this.request.setAttribute(name, value);
        return old;
    }

    @Override
    public Object remove(Object key) {
        Object old = this.request.getAttribute((String)key);
        this.request.removeAttribute((String)key);
        return old;
    }

    @Override
    public void putAll(@Nullable Map<? extends String, ?> map) {
        if (map != null) {
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                this.request.setAttribute(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void clear() {
        for (String name : Collections.list(this.request.getAttributeNames())) {
            this.request.removeAttribute(name);
        }
    }

    @Override
    @NonNull
    public Set<String> keySet() {
        return new HashSet<String>(Collections.list(this.request.getAttributeNames()));
    }

    @Override
    @NonNull
    public Collection<Object> values() {
        ArrayList<Object> list = new ArrayList<Object>();
        Enumeration names = this.request.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object value = this.request.getAttribute(name);
            list.add(value);
        }
        return list;
    }

    @Override
    @NonNull
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> set = new HashSet<Map.Entry<String, Object>>();
        Enumeration names = this.request.getAttributeNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object value = this.request.getAttribute(name);
            set.add(new AbstractMap.SimpleImmutableEntry<String, Object>(name, value));
        }
        return set;
    }
}

