/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.activity.request;

import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.lang.NonNull;
import com.aspectran.web.support.http.HttpMediaTypeNotAcceptableException;
import com.aspectran.web.support.http.InvalidMediaTypeException;
import com.aspectran.web.support.http.MediaType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RequestHeaderParser {
    public static final List<MediaType> MEDIA_TYPE_ALL_LIST = Collections.singletonList(MediaType.ALL);

    private RequestHeaderParser() {
    }

    @NonNull
    public static List<MediaType> resolveAcceptContentTypes(RequestAdapter requestAdapter) throws HttpMediaTypeNotAcceptableException {
        List acceptHeaderValues = requestAdapter.getHeaderValues("Accept");
        if (acceptHeaderValues == null || acceptHeaderValues.isEmpty()) {
            return MEDIA_TYPE_ALL_LIST;
        }
        ArrayList<String> headerValues = new ArrayList<String>(acceptHeaderValues);
        try {
            List<MediaType> mediaTypes = MediaType.parseMediaTypes(headerValues);
            MediaType.sortBySpecificityAndQuality(mediaTypes);
            if (mediaTypes != null && !mediaTypes.isEmpty()) {
                return mediaTypes;
            }
            return MEDIA_TYPE_ALL_LIST;
        }
        catch (InvalidMediaTypeException e) {
            throw new HttpMediaTypeNotAcceptableException("Could not parse 'Accept' header " + headerValues + ": " + e.getMessage());
        }
    }
}

