/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.activity.request;

import com.aspectran.core.activity.request.RequestBodyParser;
import com.aspectran.core.activity.request.RequestParseException;
import com.aspectran.core.activity.request.SizeLimitExceededException;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.lang.Nullable;
import com.aspectran.core.util.ClassUtils;
import com.aspectran.core.util.LinkedMultiValueMap;
import com.aspectran.core.util.MultiValueMap;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.apon.JsonToApon;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.core.util.apon.XmlToApon;
import com.aspectran.web.support.http.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;

public class WebRequestBodyParser {
    private static final String DEFAULT_ENCODING = "ISO-8859-1";
    private static final int BUFFER_SIZE = 1024;

    private WebRequestBodyParser() {
    }

    public static String parseBody(InputStream inputStream, String encoding) throws IOException, SizeLimitExceededException {
        return WebRequestBodyParser.parseBody(inputStream, encoding, 0L);
    }

    public static String parseBody(InputStream inputStream, String encoding, long maxSize) throws IOException, SizeLimitExceededException {
        int bytesRead;
        StringBuilder sb = new StringBuilder();
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        InputStreamReader reader = new InputStreamReader(inputStream, encoding);
        char[] buffer = new char[1024];
        long bytesTotal = 0L;
        while ((bytesRead = reader.read(buffer)) != -1) {
            if (maxSize > 0L && (bytesTotal += (long)bytesRead) > maxSize) {
                throw new SizeLimitExceededException("Maximum request size exceeded; actual: " + bytesTotal + "; permitted: " + maxSize, bytesTotal, maxSize);
            }
            sb.append(buffer, 0, bytesRead);
        }
        return sb.toString();
    }

    public static MultiValueMap<String, String> parseURLEncoded(String body, String encoding) throws UnsupportedEncodingException {
        String[] pairs;
        if (StringUtils.isEmpty((String)body)) {
            return null;
        }
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        for (String pair : pairs = StringUtils.tokenize((String)body, (String)"&")) {
            String name;
            int idx = pair.indexOf(61);
            if (idx == -1) {
                name = URLDecoder.decode(pair, encoding);
                multiValueMap.add((Object)name, null);
                continue;
            }
            name = URLDecoder.decode(pair.substring(0, idx), encoding);
            String value = URLDecoder.decode(pair.substring(idx + 1), encoding);
            multiValueMap.add((Object)name, (Object)value);
        }
        return multiValueMap;
    }

    public static void parseURLEncodedFormData(RequestAdapter requestAdapter) throws RequestParseException {
        try {
            String body = requestAdapter.getBody();
            String encoding = requestAdapter.getEncoding();
            MultiValueMap<String, String> multiValueMap = WebRequestBodyParser.parseURLEncoded(body, encoding);
            if (multiValueMap != null) {
                requestAdapter.putAllParameters(multiValueMap);
                requestAdapter.setBody(null);
            }
        }
        catch (Exception e) {
            throw new RequestParseException("Could not parse HTTP " + requestAdapter.getRequestMethod() + " request body", (Throwable)e);
        }
    }

    public static <T extends Parameters> T parseURLEncodedAsParameters(RequestAdapter requestAdapter, Class<T> requiredType) throws RequestParseException {
        try {
            MultiValueMap<String, String> multiValueMap;
            String encoding = requestAdapter.getEncoding();
            if (encoding == null) {
                encoding = DEFAULT_ENCODING;
            }
            if ((multiValueMap = WebRequestBodyParser.parseURLEncoded(requestAdapter.getBody(), encoding)) != null && !multiValueMap.isEmpty()) {
                Parameters parameters = (Parameters)ClassUtils.createInstance(requiredType);
                for (Map.Entry entry : multiValueMap.entrySet()) {
                    String name = (String)entry.getKey();
                    for (String value : (List)entry.getValue()) {
                        parameters.putValue(name, (Object)value);
                    }
                }
                return (T)parameters;
            }
        }
        catch (Exception e) {
            throw new RequestParseException("Failed to parse URL-encoded form request body to required type [" + requiredType.getName() + "]", (Throwable)e);
        }
        return null;
    }

    public static <T extends Parameters> T parseBodyAsParameters(RequestAdapter requestAdapter, @Nullable MediaType mediaType, Class<T> requiredType) throws RequestParseException {
        if (mediaType == null) {
            return null;
        }
        if (WebRequestBodyParser.isURLEncodedForm(mediaType)) {
            return WebRequestBodyParser.parseURLEncodedAsParameters(requestAdapter, requiredType);
        }
        if (MediaType.APPLICATION_JSON.equalsTypeAndSubtype(mediaType)) {
            try {
                return (T)JsonToApon.from((String)requestAdapter.getBody(), requiredType);
            }
            catch (IOException e) {
                throw new RequestParseException("Failed to parse request body of JSON format to required type [" + requiredType.getName() + "]", (Throwable)e);
            }
        }
        if (MediaType.APPLICATION_APON.equalsTypeAndSubtype(mediaType)) {
            return (T)RequestBodyParser.parseBodyAsParameters((String)requestAdapter.getBody(), requiredType);
        }
        if (MediaType.APPLICATION_XML.equalsTypeAndSubtype(mediaType)) {
            try {
                return (T)XmlToApon.from((String)requestAdapter.getBody(), requiredType);
            }
            catch (IOException e) {
                throw new RequestParseException("Failed to parse request body of XML format to required type [" + requiredType.getName() + "]", (Throwable)e);
            }
        }
        return null;
    }

    public static boolean isMultipartForm(MethodType requestMethod, MediaType mediaType) {
        return MethodType.POST.equals((Object)requestMethod) && MediaType.MULTIPART_FORM_DATA.equalsTypeAndSubtype(mediaType);
    }

    public static boolean isURLEncodedForm(MediaType mediaType) {
        return MediaType.APPLICATION_FORM_URLENCODED.equalsTypeAndSubtype(mediaType);
    }
}

