/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.activity.response;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.FormattingContext;
import com.aspectran.core.activity.response.transform.AponTransformResponse;
import com.aspectran.core.activity.response.transform.XmlTransformResponse;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.util.Assert;
import com.aspectran.core.util.apon.ObjectToAponConverter;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.core.util.json.JsonWriter;
import com.aspectran.web.activity.response.AbstractRestResponse;
import com.aspectran.web.support.http.HttpMediaTypeNotAcceptableException;
import com.aspectran.web.support.http.HttpStatus;
import com.aspectran.web.support.http.MediaType;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;

public class DefaultRestResponse
extends AbstractRestResponse {
    private static final int MAX_INDENT = 8;
    private static final List<MediaType> supportedContentTypes;
    private static final Map<String, MediaType> supportedPathExtensions;

    public DefaultRestResponse() {
    }

    public DefaultRestResponse(Object data) {
        super(data);
    }

    public DefaultRestResponse(String label, Object data) {
        super(label, data);
    }

    @Override
    protected List<MediaType> getSupportedContentTypes() {
        return supportedContentTypes;
    }

    @Override
    protected MediaType getContentTypeByPathExtension(String extension) {
        return supportedPathExtensions.get(extension);
    }

    public void transform(Activity activity) throws Exception {
        MediaType contentType;
        Assert.notNull((Object)activity, (String)"activity must not be null");
        ResponseAdapter responseAdapter = activity.getResponseAdapter();
        String encoding = this.determineEncoding(activity);
        if (encoding != null) {
            responseAdapter.setEncoding(encoding);
        }
        try {
            contentType = this.determineContentType(activity);
        }
        catch (HttpMediaTypeNotAcceptableException e) {
            responseAdapter.setStatus(HttpStatus.NOT_ACCEPTABLE.value());
            return;
        }
        responseAdapter.setContentType(contentType.toString());
        this.transformByContentType(activity, encoding, contentType);
        if (this.getStatus() > 0) {
            responseAdapter.setStatus(this.getStatus());
            if (this.getStatus() == HttpStatus.CREATED.value() && this.getLocation() != null) {
                responseAdapter.setHeader("Location", this.getLocation());
            }
        }
    }

    public String getContentType(Activity activity) {
        try {
            MediaType contentType = this.determineContentType(activity);
            return contentType != null ? contentType.toString() : null;
        }
        catch (HttpMediaTypeNotAcceptableException e) {
            return null;
        }
    }

    protected void transformByContentType(Activity activity, String encoding, MediaType contentType) throws Exception {
        if (MediaType.APPLICATION_JSON.equalsTypeAndSubtype(contentType)) {
            this.toJSON(activity, this.parseIndent(contentType));
        } else if (MediaType.APPLICATION_APON.equalsTypeAndSubtype(contentType)) {
            this.toAPON(activity, this.parseIndent(contentType));
        } else if (MediaType.APPLICATION_XML.equalsTypeAndSubtype(contentType)) {
            this.toXML(activity, encoding, this.parseIndent(contentType));
        } else {
            this.toText(activity);
        }
    }

    private void toJSON(Activity activity, int indent) throws IOException {
        RequestAdapter requestAdapter = activity.getRequestAdapter();
        ResponseAdapter responseAdapter = activity.getResponseAdapter();
        Writer writer = responseAdapter.getWriter();
        String callback = requestAdapter.getParameter("callback");
        if (callback != null) {
            writer.write(callback + "(");
        }
        if (this.getName() != null || this.getData() != null) {
            FormattingContext formattingContext = FormattingContext.parse((Activity)activity);
            formattingContext.setPretty(this.isPrettyPrint());
            if (this.isPrettyPrint() && indent > -1) {
                formattingContext.setIndentSize(indent);
            }
            JsonWriter jsonWriter = new JsonWriter(writer);
            if (formattingContext.getDateFormat() != null) {
                jsonWriter.dateFormat(formattingContext.getDateFormat());
            }
            if (formattingContext.getDateTimeFormat() != null) {
                jsonWriter.dateTimeFormat(formattingContext.getDateTimeFormat());
            }
            if (formattingContext.getNullWritable() != null) {
                jsonWriter.nullWritable(formattingContext.getNullWritable().booleanValue());
            }
            if (formattingContext.isPretty()) {
                String indentString = formattingContext.makeIndentString();
                if (indentString != null) {
                    jsonWriter.indentString(indentString);
                } else {
                    jsonWriter.prettyPrint(true);
                }
            } else {
                jsonWriter.prettyPrint(false);
            }
            if (this.getName() != null) {
                jsonWriter.beginObject();
                jsonWriter.writeName(this.getName());
            }
            jsonWriter.write(this.getData());
            if (this.getName() != null) {
                jsonWriter.endObject();
            }
        }
        if (callback != null) {
            writer.write(")");
        }
    }

    private void toAPON(Activity activity, int indent) throws IOException {
        if (this.getName() != null || this.getData() != null) {
            ResponseAdapter responseAdapter = activity.getResponseAdapter();
            Writer writer = responseAdapter.getWriter();
            FormattingContext formattingContext = FormattingContext.parse((Activity)activity);
            formattingContext.setPretty(this.isPrettyPrint());
            if (this.isPrettyPrint() && indent > -1) {
                formattingContext.setIndentSize(indent);
            }
            ObjectToAponConverter aponConverter = new ObjectToAponConverter();
            if (formattingContext.getDateFormat() != null) {
                aponConverter.setDateFormat(formattingContext.getDateFormat());
            }
            if (formattingContext.getDateTimeFormat() != null) {
                aponConverter.setDateTimeFormat(formattingContext.getDateTimeFormat());
            }
            Parameters parameters = aponConverter.toParameters(this.getName(), this.getData());
            AponTransformResponse.transform((Parameters)parameters, (Writer)writer, (FormattingContext)formattingContext);
        }
    }

    private void toXML(Activity activity, String encoding, int indent) throws IOException, TransformerException {
        if (this.getName() != null || this.getData() != null) {
            ResponseAdapter responseAdapter = activity.getResponseAdapter();
            Writer writer = responseAdapter.getWriter();
            FormattingContext formattingContext = FormattingContext.parse((Activity)activity);
            formattingContext.setPretty(this.isPrettyPrint());
            if (this.isPrettyPrint() && indent > -1) {
                formattingContext.setIndentSize(indent);
            }
            if (this.getName() != null) {
                XmlTransformResponse.transform(Collections.singletonMap(this.getName(), this.getData()), (Writer)writer, (String)encoding, (FormattingContext)formattingContext);
            } else {
                XmlTransformResponse.transform((Object)this.getData(), (Writer)writer, (String)encoding, (FormattingContext)formattingContext);
            }
        }
    }

    private void toText(Activity activity) throws IOException {
        if (this.getName() != null || this.getData() != null) {
            ResponseAdapter responseAdapter = activity.getResponseAdapter();
            Writer writer = responseAdapter.getWriter();
            if (this.getName() != null) {
                writer.write(this.getName());
                writer.write(": ");
            }
            if (this.getData() != null) {
                writer.write(this.getData().toString());
            }
        }
    }

    private int parseIndent(MediaType contentType) {
        try {
            int depth;
            String indent = contentType.getParameter("indent");
            if (indent != null && (depth = Integer.parseInt(indent)) >= 0) {
                if (depth > 8) {
                    depth = 8;
                }
                return depth;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }

    static {
        ArrayList<MediaType> contentTypes = new ArrayList<MediaType>();
        contentTypes.add(MediaType.TEXT_PLAIN);
        contentTypes.add(MediaType.TEXT_HTML);
        contentTypes.add(MediaType.APPLICATION_JSON);
        contentTypes.add(MediaType.APPLICATION_APON);
        contentTypes.add(MediaType.APPLICATION_XML);
        supportedContentTypes = Collections.unmodifiableList(contentTypes);
        HashMap<String, MediaType> pathExtensions = new HashMap<String, MediaType>();
        pathExtensions.put("json", MediaType.APPLICATION_JSON);
        pathExtensions.put("apon", MediaType.APPLICATION_APON);
        pathExtensions.put("xml", MediaType.APPLICATION_XML);
        pathExtensions.put("txt", MediaType.TEXT_PLAIN);
        pathExtensions.put("html", MediaType.TEXT_HTML);
        pathExtensions.put("htm", MediaType.TEXT_HTML);
        supportedPathExtensions = Collections.unmodifiableMap(pathExtensions);
    }
}

