/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.adapter;

import com.aspectran.core.activity.request.RequestParseException;
import com.aspectran.core.adapter.AbstractRequestAdapter;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.util.MultiValueMap;
import com.aspectran.core.util.apon.Parameters;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import com.aspectran.web.activity.request.RequestAttributeMap;
import com.aspectran.web.activity.request.WebRequestBodyParser;
import com.aspectran.web.support.http.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class HttpServletRequestAdapter
extends AbstractRequestAdapter {
    private static final Logger logger = LoggerFactory.getLogger(HttpServletRequestAdapter.class);
    private boolean headersObtained;
    private boolean bodyObtained;
    private MediaType mediaType;

    public HttpServletRequestAdapter(MethodType requestMethod, HttpServletRequest request) {
        super(requestMethod, (Object)request);
    }

    public MultiValueMap<String, String> getHeaderMap() {
        if (!this.headersObtained) {
            this.headersObtained = true;
            HttpServletRequest request = (HttpServletRequest)this.getAdaptee();
            Enumeration headerNames = request.getHeaderNames();
            if (headerNames.hasMoreElements()) {
                MultiValueMap multiValueMap = super.getHeaderMap();
                while (headerNames.hasMoreElements()) {
                    String name = (String)headerNames.nextElement();
                    Enumeration values = request.getHeaders(name);
                    while (values.hasMoreElements()) {
                        String value = (String)values.nextElement();
                        multiValueMap.add((Object)name, (Object)value);
                    }
                }
            }
        }
        return super.getHeaderMap();
    }

    public String getEncoding() {
        return ((HttpServletRequest)this.getAdaptee()).getCharacterEncoding();
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        ((HttpServletRequest)this.getAdaptee()).setCharacterEncoding(encoding);
    }

    public InputStream getInputStream() throws IOException {
        return ((HttpServletRequest)this.getAdaptee()).getInputStream();
    }

    public String getBody() {
        if (!this.bodyObtained) {
            this.bodyObtained = true;
            try {
                String body = WebRequestBodyParser.parseBody(this.getInputStream(), this.getEncoding(), this.getMaxRequestSize());
                this.setBody(body);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to parse request body", (Throwable)e);
                }
                this.setBody(null);
            }
        }
        return super.getBody();
    }

    public <T extends Parameters> T getBodyAsParameters(Class<T> requiredType) throws RequestParseException {
        if (this.getMediaType() != null) {
            return WebRequestBodyParser.parseBodyAsParameters((RequestAdapter)this, this.getMediaType(), requiredType);
        }
        return null;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    private void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public void preparse() {
        HttpServletRequest request = (HttpServletRequest)this.getAdaptee();
        Map parameters = request.getParameterMap();
        if (!parameters.isEmpty()) {
            this.getParameterMap().putAll(parameters);
        }
        this.setAttributeMap(new RequestAttributeMap(request));
        if (request.getContentType() != null) {
            this.setMediaType(MediaType.parseMediaType(request.getContentType()));
        }
        this.setLocale(request.getLocale());
    }

    public void preparse(HttpServletRequestAdapter requestAdapter) {
        this.getParameterMap().putAll((Map)requestAdapter.getParameterMap());
        this.setAttributeMap(requestAdapter.getAttributeMap());
        this.setMediaType(requestAdapter.getMediaType());
        this.setLocale(requestAdapter.getLocale());
    }
}

