/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.adapter;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.ResponseException;
import com.aspectran.core.activity.response.transform.TransformResponse;
import com.aspectran.core.adapter.AbstractResponseAdapter;
import com.aspectran.core.context.expr.ItemEvaluation;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.RedirectRule;
import com.aspectran.core.context.rule.type.FormatType;
import com.aspectran.web.support.util.SendRedirectBasedOnXForwardedProtocol;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;

public class HttpServletResponseAdapter
extends AbstractResponseAdapter {
    public static final String PROXY_PROTOCOL_AWARE_SETTING_NAME = "proxyProtocolAware";
    private static final char QUESTION_CHAR = '?';
    private static final char AMPERSAND_CHAR = '&';
    private static final char EQUAL_CHAR = '=';
    private final Activity activity;
    private boolean precommitDone;

    public HttpServletResponseAdapter(HttpServletResponse response, Activity activity) {
        super((Object)response);
        this.activity = activity;
    }

    public String getHeader(String name) {
        return ((HttpServletResponse)this.getAdaptee()).getHeader(name);
    }

    public Collection<String> getHeaders(String name) {
        return ((HttpServletResponse)this.getAdaptee()).getHeaders(name);
    }

    public Collection<String> getHeaderNames() {
        return ((HttpServletResponse)this.getAdaptee()).getHeaderNames();
    }

    public boolean containsHeader(String name) {
        return ((HttpServletResponse)this.getAdaptee()).containsHeader(name);
    }

    public void setHeader(String name, String value) {
        ((HttpServletResponse)this.getAdaptee()).setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        ((HttpServletResponse)this.getAdaptee()).addHeader(name, value);
    }

    public String getEncoding() {
        return ((HttpServletResponse)this.getAdaptee()).getCharacterEncoding();
    }

    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        ((HttpServletResponse)this.getAdaptee()).setCharacterEncoding(encoding);
    }

    public String getContentType() {
        return ((HttpServletResponse)this.getAdaptee()).getContentType();
    }

    public void setContentType(String contentType) {
        ((HttpServletResponse)this.getAdaptee()).setContentType(contentType);
    }

    public OutputStream getOutputStream() throws IOException {
        this.precommit();
        return ((HttpServletResponse)this.getAdaptee()).getOutputStream();
    }

    public Writer getWriter() throws IOException {
        this.precommit();
        return ((HttpServletResponse)this.getAdaptee()).getWriter();
    }

    public void flush() throws IOException {
        if (((HttpServletResponse)this.getAdaptee()).isCommitted()) {
            ((HttpServletResponse)this.getAdaptee()).flushBuffer();
        }
    }

    public void redirect(String location) throws IOException {
        boolean proxyProtocolAware = Boolean.parseBoolean((String)this.activity.getSetting(PROXY_PROTOCOL_AWARE_SETTING_NAME));
        if (proxyProtocolAware) {
            location = SendRedirectBasedOnXForwardedProtocol.getLocation(this.activity.getTranslet(), location);
        }
        ((HttpServletResponse)this.getAdaptee()).sendRedirect(location);
    }

    public String redirect(RedirectRule redirectRule) throws IOException {
        String path = HttpServletResponseAdapter.makeRedirectPath(redirectRule, this.activity);
        this.redirect(path);
        return path;
    }

    public int getStatus() {
        return ((HttpServletResponse)this.getAdaptee()).getStatus();
    }

    public void setStatus(int status) {
        ((HttpServletResponse)this.getAdaptee()).setStatus(status);
    }

    private void precommit() throws IOException {
        if (!this.precommitDone) {
            FormatType formatType;
            this.precommitDone = true;
            Response response = this.activity.getDeclaredResponse();
            if (response instanceof TransformResponse && (formatType = ((TransformResponse)response).getFormatType()) == null) {
                try {
                    response.commit(this.activity);
                }
                catch (ResponseException e) {
                    throw new IOException("Error during precommit", e);
                }
            }
        }
    }

    public static String makeRedirectPath(RedirectRule redirectRule, Activity activity) throws IOException {
        ItemEvaluation evaluator;
        Map valueMap;
        ItemRuleMap parameterItemRuleMap;
        if (redirectRule == null) {
            throw new IllegalArgumentException("redirectRule must not be null");
        }
        if (redirectRule.getEncoding() == null) {
            redirectRule.setEncoding(StandardCharsets.ISO_8859_1.name());
        }
        String path = redirectRule.getPath(activity);
        int questionPos = -1;
        StringBuilder sb = new StringBuilder(256);
        if (path != null) {
            sb.append(path);
            questionPos = path.indexOf(63);
        }
        if ((parameterItemRuleMap = redirectRule.getParameterItemRuleMap()) != null && !parameterItemRuleMap.isEmpty() && (valueMap = (evaluator = new ItemEvaluation(activity)).evaluate(parameterItemRuleMap)) != null && !valueMap.isEmpty()) {
            if (questionPos == -1) {
                sb.append('?');
            }
            String name = null;
            for (Map.Entry entry : valueMap.entrySet()) {
                String stringValue;
                if (name != null) {
                    sb.append('&');
                }
                name = (String)entry.getKey();
                Object value = entry.getValue();
                String string = stringValue = value != null ? value.toString() : null;
                if (redirectRule.isExcludeEmptyParameters() && stringValue != null && !stringValue.isEmpty()) {
                    sb.append(name).append('=');
                } else if (redirectRule.isExcludeNullParameters() && stringValue != null) {
                    sb.append(name).append('=');
                } else {
                    sb.append(name).append('=');
                }
                if (stringValue == null) continue;
                stringValue = URLEncoder.encode(stringValue, redirectRule.getEncoding());
                sb.append(stringValue);
            }
        }
        return sb.toString();
    }
}

