/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.adapter;

import com.aspectran.core.adapter.AbstractSessionAdapter;
import com.aspectran.core.component.bean.scope.SessionScope;
import com.aspectran.web.adapter.HttpSessionScope;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class HttpSessionAdapter
extends AbstractSessionAdapter {
    public HttpSessionAdapter(HttpServletRequest request) {
        super((Object)request);
    }

    public <T> T getAdaptee() {
        return (T)this.getSession(true);
    }

    public SessionScope newSessionScope() {
        return new HttpSessionScope();
    }

    public String getId() {
        return this.getSession(true).getId();
    }

    public long getCreationTime() {
        return this.getSession(true).getCreationTime();
    }

    public long getLastAccessedTime() {
        return this.getSession(true).getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.getSession(true).getMaxInactiveInterval();
    }

    public void setMaxInactiveInterval(int interval) {
        this.getSession(true).setMaxInactiveInterval(interval);
    }

    public Enumeration<String> getAttributeNames() {
        HttpSession session = this.getSession(false);
        if (session != null) {
            return session.getAttributeNames();
        }
        return null;
    }

    public <T> T getAttribute(String name) {
        HttpSession session = this.getSession(false);
        if (session != null) {
            return (T)session.getAttribute(name);
        }
        return null;
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            HttpSession session = this.getSession(true);
            session.setAttribute(name, value);
        } else {
            HttpSession session = this.getSession(false);
            if (session != null) {
                session.removeAttribute(name);
            }
        }
    }

    public void removeAttribute(String name) {
        HttpSession session = this.getSession(false);
        if (session != null) {
            session.removeAttribute(name);
        }
    }

    public void invalidate() {
        HttpSession session = this.getSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    public boolean isNew() {
        HttpSession session = this.getSession(false);
        if (session == null) {
            return true;
        }
        return session.isNew();
    }

    public HttpSession getSession(boolean create) {
        return ((HttpServletRequest)super.getAdaptee()).getSession(create);
    }
}

