/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.service;

import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultServletHttpRequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultServletHttpRequestHandler.class);
    private static final String COMMON_DEFAULT_SERVLET_NAME = "default";
    private static final String RESIN_DEFAULT_SERVLET_NAME = "resin-file";
    private static final String WEBLOGIC_DEFAULT_SERVLET_NAME = "FileServlet";
    private static final String WEBSPHERE_DEFAULT_SERVLET_NAME = "SimpleFileServlet";
    private static final String GAE_DEFAULT_SERVLET_NAME = "_ah_default";
    private static final String JEUS_DEFAULT_SERVLET_NAME = "WorkerServlet";
    private final ServletContext servletContext;
    private String defaultServletName;

    public DefaultServletHttpRequestHandler(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.lookupDefaultServletName(servletContext);
    }

    public String getDefaultServletName() {
        return this.defaultServletName;
    }

    public void setDefaultServletName(String defaultServletName) {
        this.defaultServletName = defaultServletName;
    }

    private void lookupDefaultServletName(ServletContext servletContext) {
        if (servletContext.getNamedDispatcher(COMMON_DEFAULT_SERVLET_NAME) != null) {
            this.defaultServletName = COMMON_DEFAULT_SERVLET_NAME;
        } else if (servletContext.getNamedDispatcher(RESIN_DEFAULT_SERVLET_NAME) != null) {
            this.defaultServletName = RESIN_DEFAULT_SERVLET_NAME;
        } else if (servletContext.getNamedDispatcher(WEBLOGIC_DEFAULT_SERVLET_NAME) != null) {
            this.defaultServletName = WEBLOGIC_DEFAULT_SERVLET_NAME;
        } else if (servletContext.getNamedDispatcher(WEBSPHERE_DEFAULT_SERVLET_NAME) != null) {
            this.defaultServletName = WEBSPHERE_DEFAULT_SERVLET_NAME;
        } else if (servletContext.getNamedDispatcher(GAE_DEFAULT_SERVLET_NAME) != null) {
            this.defaultServletName = GAE_DEFAULT_SERVLET_NAME;
        } else if (servletContext.getNamedDispatcher(JEUS_DEFAULT_SERVLET_NAME) != null) {
            this.defaultServletName = JEUS_DEFAULT_SERVLET_NAME;
        } else if (logger.isDebugEnabled()) {
            logger.debug("Unable to locate the default servlet for serving static content. Please set the 'web.defaultServletName' property explicitly.");
        }
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.defaultServletName != null) {
            RequestDispatcher rd = this.servletContext.getNamedDispatcher(this.defaultServletName);
            if (rd == null) {
                throw new IllegalStateException("A RequestDispatcher could not be located for the default servlet '" + this.defaultServletName + "'");
            }
            rd.forward((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        return false;
    }
}

