/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.service;

import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.activity.TransletNotFoundException;
import com.aspectran.core.activity.request.RequestMethodNotAllowedException;
import com.aspectran.core.activity.request.SizeLimitExceededException;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.ContextConfig;
import com.aspectran.core.context.config.ExposalsConfig;
import com.aspectran.core.context.config.WebConfig;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.service.AspectranCoreService;
import com.aspectran.core.service.AspectranServiceException;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.service.ServiceStateListener;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import com.aspectran.web.activity.WebActivity;
import com.aspectran.web.service.DefaultServletHttpRequestHandler;
import com.aspectran.web.service.WebService;
import com.aspectran.web.service.WebServiceHolder;
import com.aspectran.web.startup.servlet.WebActivityServlet;
import com.aspectran.web.support.http.HttpStatus;
import java.io.IOException;
import java.net.URLDecoder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultWebService
extends AspectranCoreService
implements WebService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultWebService.class);
    private static final String ASPECTRAN_CONFIG_PARAM = "aspectran:config";
    private static final String DEFAULT_APP_CONFIG_ROOT_FILE = "/WEB-INF/aspectran/app-config.xml";
    private final ServletContext servletContext;
    private final DefaultServletHttpRequestHandler defaultServletHttpRequestHandler;
    private String uriDecoding;
    private volatile long pauseTimeout = -2L;

    private DefaultWebService(ServletContext servletContext) {
        this.servletContext = servletContext;
        this.defaultServletHttpRequestHandler = new DefaultServletHttpRequestHandler(servletContext);
        this.setBasePath(servletContext.getRealPath("/"));
    }

    private DefaultWebService(ServletContext servletContext, CoreService rootService) {
        super(rootService);
        this.servletContext = servletContext;
        this.defaultServletHttpRequestHandler = new DefaultServletHttpRequestHandler(servletContext);
    }

    @Override
    public ServletContext getServletContext() {
        return this.servletContext;
    }

    protected void setUriDecoding(String uriDecoding) {
        this.uriDecoding = uriDecoding;
    }

    @Override
    public void execute(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block24: {
            String requestUri = request.getRequestURI();
            if (this.uriDecoding != null) {
                requestUri = URLDecoder.decode(requestUri, this.uriDecoding);
            }
            if (!this.isExposable(requestUri)) {
                try {
                    if (!this.defaultServletHttpRequestHandler.handleRequest(request, response)) {
                        response.sendError(404);
                    }
                }
                catch (Exception e) {
                    logger.error("An error occurred while processing by the default servlet", (Throwable)e);
                    response.sendError(500);
                }
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug(this.getRequestInfo(request));
            }
            if (this.pauseTimeout != 0L) {
                if (this.pauseTimeout == -1L || this.pauseTimeout >= System.currentTimeMillis()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(this.getServiceName() + " has been paused, so did not respond to the request URI \"" + requestUri + "\"");
                    }
                    response.sendError(503);
                    return;
                }
                if (this.pauseTimeout == -2L) {
                    logger.error(this.getServiceName() + " is not yet started");
                    response.sendError(503);
                    return;
                }
                this.pauseTimeout = 0L;
            }
            try {
                WebActivity activity = new WebActivity(this.getActivityContext(), request, response);
                activity.prepare(requestUri, request.getMethod());
                activity.perform();
            }
            catch (TransletNotFoundException e) {
                String transletName = e.getTransletName();
                if (StringUtils.startsWith((String)transletName, (char)'/') && !StringUtils.endsWith((String)transletName, (char)'/')) {
                    String transletNameWithSlash = transletName + '/';
                    MethodType requestMethod = e.getRequestMethod(MethodType.GET);
                    if (this.getActivityContext().getTransletRuleRegistry().contains(transletNameWithSlash, requestMethod)) {
                        response.setStatus(HttpStatus.MOVED_PERMANENTLY.value());
                        response.setHeader("Location", transletNameWithSlash);
                        response.setHeader("Connection", "close");
                        if (logger.isDebugEnabled()) {
                            logger.debug("Redirect URL with Trailing Slash: " + e.getTransletName());
                        }
                        return;
                    }
                }
                try {
                    if (!this.defaultServletHttpRequestHandler.handleRequest(request, response)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("No translet mapped for request URI [" + requestUri + "]");
                        }
                        response.sendError(404);
                    }
                }
                catch (Exception e2) {
                    logger.error((Throwable)e2);
                    response.sendError(500);
                }
            }
            catch (ActivityTerminatedException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Activity terminated: " + e.getMessage());
                }
            }
            catch (Exception e) {
                logger.error("An error occurred while processing request: " + requestUri, (Throwable)e);
                if (response.isCommitted()) break block24;
                if (e.getCause() instanceof RequestMethodNotAllowedException) {
                    response.sendError(405);
                }
                if (e.getCause() instanceof SizeLimitExceededException) {
                    response.sendError(413);
                }
                response.sendError(500);
            }
        }
    }

    private String getRequestInfo(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append(request.getMethod()).append(" ");
        sb.append(request.getRequestURI()).append(" ");
        sb.append(request.getProtocol()).append(" ");
        String remoteAddr = request.getHeader("X-FORWARDED-FOR");
        if (!StringUtils.isEmpty((String)remoteAddr)) {
            sb.append(remoteAddr);
        } else {
            sb.append(request.getRemoteAddr());
        }
        return sb.toString();
    }

    private DefaultServletHttpRequestHandler getDefaultServletHttpRequestHandler() {
        return this.defaultServletHttpRequestHandler;
    }

    public static DefaultWebService create(ServletContext servletContext) {
        String aspectranConfigParam = servletContext.getInitParameter(ASPECTRAN_CONFIG_PARAM);
        if (aspectranConfigParam == null) {
            logger.warn("No specified servlet context initialization parameter for instantiating WebService");
        }
        DefaultWebService service = DefaultWebService.create(servletContext, aspectranConfigParam);
        servletContext.setAttribute(ROOT_WEB_SERVICE_ATTR_NAME, (Object)service);
        if (logger.isDebugEnabled()) {
            logger.debug("The Root WebService attribute in ServletContext has been created; " + ROOT_WEB_SERVICE_ATTR_NAME + ": " + service);
        }
        WebServiceHolder.putWebService(service);
        return service;
    }

    public static DefaultWebService create(ServletContext servletContext, CoreService rootService) {
        WebConfig webConfig;
        DefaultWebService service = new DefaultWebService(servletContext, rootService);
        AspectranConfig aspectranConfig = rootService.getAspectranConfig();
        if (aspectranConfig != null && (webConfig = aspectranConfig.getWebConfig()) != null) {
            DefaultWebService.applyWebConfig(service, webConfig);
        }
        DefaultWebService.setServiceStateListener(service);
        if (service.isLateStart()) {
            try {
                service.getServiceController().start();
            }
            catch (Exception e) {
                throw new AspectranServiceException("Failed to start DefaultWebService");
            }
        }
        WebServiceHolder.putWebService(service);
        return service;
    }

    public static DefaultWebService create(WebActivityServlet servlet) {
        ServletContext servletContext = servlet.getServletContext();
        ServletConfig servletConfig = servlet.getServletConfig();
        String aspectranConfigParam = servletConfig.getInitParameter(ASPECTRAN_CONFIG_PARAM);
        if (aspectranConfigParam == null) {
            logger.warn("No specified servlet initialization parameter for instantiating DefaultWebService");
        }
        DefaultWebService service = DefaultWebService.create(servletContext, aspectranConfigParam);
        String attrName = STANDALONE_WEB_SERVICE_ATTR_PREFIX + servlet.getServletName();
        servletContext.setAttribute(attrName, (Object)service);
        if (logger.isDebugEnabled()) {
            logger.debug("The Standalone WebService attribute in ServletContext has been created; " + attrName + ": " + service);
        }
        WebServiceHolder.putWebService(service);
        return service;
    }

    public static DefaultWebService create(WebActivityServlet servlet, DefaultWebService rootService) {
        ServletContext servletContext = servlet.getServletContext();
        ServletConfig servletConfig = servlet.getServletConfig();
        String aspectranConfigParam = servletConfig.getInitParameter(ASPECTRAN_CONFIG_PARAM);
        if (aspectranConfigParam != null) {
            DefaultWebService service = DefaultWebService.create(servletContext, aspectranConfigParam);
            String attrName = STANDALONE_WEB_SERVICE_ATTR_PREFIX + servlet.getServletName();
            servletContext.setAttribute(attrName, (Object)service);
            if (logger.isDebugEnabled()) {
                logger.debug("The Standalone WebService attribute in ServletContext has been created; " + attrName + ": " + service);
            }
            WebServiceHolder.putWebService(service);
            return service;
        }
        WebServiceHolder.putWebService(rootService);
        return rootService;
    }

    private static DefaultWebService create(ServletContext servletContext, String aspectranConfigParam) {
        AspectranConfig aspectranConfig;
        if (aspectranConfigParam != null) {
            try {
                aspectranConfig = new AspectranConfig(aspectranConfigParam);
            }
            catch (IOException e) {
                throw new AspectranServiceException("Error parsing 'aspectran:config' initialization parameter for Aspectran Configuration", (Throwable)e);
            }
        } else {
            aspectranConfig = new AspectranConfig();
        }
        ContextConfig contextConfig = aspectranConfig.touchContextConfig();
        String rootFile = contextConfig.getRootFile();
        if (!StringUtils.hasText((String)rootFile) && !contextConfig.hasAspectranParameters()) {
            contextConfig.setRootFile(DEFAULT_APP_CONFIG_ROOT_FILE);
        }
        DefaultWebService service = new DefaultWebService(servletContext);
        service.prepare(aspectranConfig);
        WebConfig webConfig = aspectranConfig.getWebConfig();
        if (webConfig != null) {
            DefaultWebService.applyWebConfig(service, webConfig);
        }
        DefaultWebService.setServiceStateListener(service);
        return service;
    }

    private static void applyWebConfig(DefaultWebService service, WebConfig webConfig) {
        ExposalsConfig exposalsConfig;
        service.setUriDecoding(webConfig.getUriDecoding());
        String defaultServletName = webConfig.getDefaultServletName();
        if (defaultServletName != null) {
            service.getDefaultServletHttpRequestHandler().setDefaultServletName(defaultServletName);
        }
        if ((exposalsConfig = webConfig.getExposalsConfig()) != null) {
            String[] includePatterns = exposalsConfig.getIncludePatterns();
            String[] excludePatterns = exposalsConfig.getExcludePatterns();
            service.setExposals(includePatterns, excludePatterns);
        }
    }

    private static void setServiceStateListener(final DefaultWebService service) {
        service.setServiceStateListener(new ServiceStateListener(){

            public void started() {
                service.pauseTimeout = 0L;
            }

            public void restarted() {
                this.started();
            }

            public void paused(long millis) {
                if (millis > 0L) {
                    service.pauseTimeout = System.currentTimeMillis() + millis;
                } else {
                    logger.warn("Pause timeout in milliseconds needs to be set to a value of greater than 0");
                }
            }

            public void paused() {
                service.pauseTimeout = -1L;
            }

            public void resumed() {
                this.started();
            }

            public void stopped() {
                this.paused();
            }
        });
    }
}

