/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.service;

import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.lang.Nullable;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.util.Assert;
import com.aspectran.web.service.DefaultWebService;
import com.aspectran.web.service.WebService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;

public class WebServiceHolder {
    private static final Map<ClassLoader, WebService> webServicePerThread = new ConcurrentHashMap<ClassLoader, WebService>(1);
    @Nullable
    private static volatile WebService currentWebService;

    static void putWebService(WebService webService) {
        Assert.notNull((Object)webService, (String)"webService must not be null");
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        if (ccl == WebServiceHolder.class.getClassLoader()) {
            currentWebService = webService;
        } else if (ccl != null) {
            webServicePerThread.put(ccl, webService);
        }
    }

    static void removeWebService(WebService webService) {
        Assert.notNull((Object)webService, (String)"webService must not be null");
        webServicePerThread.entrySet().removeIf(entry -> webService.equals(entry.getValue()));
        if (currentWebService != null && currentWebService == webService) {
            currentWebService = null;
        }
    }

    public static WebService getCurrentWebService() {
        WebService webService;
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        if (ccl != null && (webService = webServicePerThread.get(ccl)) != null) {
            return webService;
        }
        return currentWebService;
    }

    public static ActivityContext getCurrentActivityContext() {
        WebService webService = WebServiceHolder.getCurrentWebService();
        return webService != null ? webService.getActivityContext() : null;
    }

    public static ActivityContext getActivityContext(ServletContext servletContext) {
        ActivityContext activityContext = WebServiceHolder.getActivityContext(servletContext, WebService.ROOT_WEB_SERVICE_ATTR_NAME);
        if (activityContext == null) {
            throw new IllegalStateException("No root DefaultWebService found; No WebServiceListener registered?");
        }
        return activityContext;
    }

    public static ActivityContext getActivityContext(HttpServlet servlet) {
        String attrName;
        ServletContext servletContext = servlet.getServletContext();
        ActivityContext activityContext = WebServiceHolder.getActivityContext(servletContext, attrName = WebService.STANDALONE_WEB_SERVICE_ATTR_PREFIX + servlet.getServletName());
        if (activityContext != null) {
            return activityContext;
        }
        return WebServiceHolder.getActivityContext(servletContext);
    }

    private static ActivityContext getActivityContext(ServletContext servletContext, String attrName) {
        Object attr = servletContext.getAttribute(attrName);
        if (attr == null) {
            return null;
        }
        if (!(attr instanceof DefaultWebService)) {
            throw new IllegalStateException("Context attribute [" + attr + "] is not of type [" + DefaultWebService.class.getName() + "]");
        }
        return ((CoreService)attr).getActivityContext();
    }
}

