/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.startup.filter;

import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import com.aspectran.core.util.wildcard.WildcardPattern;
import com.aspectran.web.service.DefaultServletHttpRequestHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebActivityFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(WebActivityFilter.class);
    private static final String BYPASS_PATTERN_DELIMITERS = ",;\t\r\n\f";
    private FilterConfig filterConfig;
    private List<WildcardPattern> bypassPatterns;
    private DefaultServletHttpRequestHandler defaultServletHttpRequestHandler;

    public void init(FilterConfig filterConfig) {
        String[] bypasses;
        this.filterConfig = filterConfig;
        String bypassesParam = filterConfig.getInitParameter("bypasses");
        if (bypassesParam != null && (bypasses = StringUtils.tokenize((String)bypassesParam, (String)BYPASS_PATTERN_DELIMITERS)).length > 0) {
            ArrayList<WildcardPattern> bypassPatterns = new ArrayList<WildcardPattern>(bypasses.length);
            for (String path : bypasses) {
                bypassPatterns.add(WildcardPattern.compile((String)path.trim(), (char)'/'));
            }
            this.bypassPatterns = bypassPatterns;
            this.defaultServletHttpRequestHandler = new DefaultServletHttpRequestHandler(filterConfig.getServletContext());
            if (logger.isDebugEnabled()) {
                for (WildcardPattern pattern : bypassPatterns) {
                    logger.debug("URI [" + pattern + "] is bypassed by " + this.getMyName() + " to servlet [" + this.defaultServletHttpRequestHandler.getDefaultServletName() + "]");
                }
            }
        }
        logger.info("Initialized " + this.getMyName());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            if (this.bypassPatterns != null) {
                for (WildcardPattern pattern : this.bypassPatterns) {
                    if (!pattern.matches(httpRequest.getRequestURI()) || !this.defaultServletHttpRequestHandler.handleRequest(httpRequest, (HttpServletResponse)response)) continue;
                    return;
                }
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
        logger.info("Destroyed " + this.getMyName());
    }

    private String getMyName() {
        return this.getClass().getSimpleName() + '@' + Integer.toString(this.hashCode(), 16) + "(" + this.filterConfig.getFilterName() + ")";
    }
}

