/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.startup.listener;

import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import com.aspectran.web.service.DefaultWebService;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class WebServiceListener
implements ServletContextListener {
    private static final Logger logger = LoggerFactory.getLogger(WebServiceListener.class);
    private DefaultWebService webService;

    public void contextInitialized(ServletContextEvent event) {
        logger.info("Initializing WebServiceListener...");
        try {
            this.webService = DefaultWebService.create(event.getServletContext());
            this.webService.start();
        }
        catch (Exception e) {
            logger.error("WebServiceListener initialization failed", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this.webService != null) {
            logger.info("Do not terminate the server while the all scoped bean destroying");
            this.webService.stop();
            this.webService = null;
            logger.info("Successfully destroyed WebServiceListener: " + this);
        }
    }
}

