/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.startup.servlet;

import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import com.aspectran.web.service.DefaultWebService;
import com.aspectran.web.service.WebService;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebActivityServlet
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = 6659683668233267847L;
    private static final Logger logger = LoggerFactory.getLogger(WebActivityServlet.class);
    private DefaultWebService webService;
    private boolean standalone;

    public void init() throws ServletException {
        try {
            ServletContext servletContext = this.getServletContext();
            Object attr = servletContext.getAttribute(WebService.ROOT_WEB_SERVICE_ATTR_NAME);
            DefaultWebService rootService = null;
            if (attr != null) {
                if (!(attr instanceof DefaultWebService)) {
                    throw new IllegalStateException("Context attribute [" + attr + "] is not of type [" + DefaultWebService.class.getName() + "]");
                }
                rootService = (DefaultWebService)attr;
                this.webService = DefaultWebService.create(this, rootService);
            } else {
                this.webService = DefaultWebService.create(this);
            }
            boolean bl = this.standalone = rootService != this.webService;
            if (this.standalone) {
                this.webService.start();
                logger.info(this.webService.getServiceName() + " is running in standalone mode inside " + this.getMyName());
            }
        }
        catch (Exception e) {
            logger.error("Unable to initialize WebActivityServlet", (Throwable)e);
            throw new UnavailableException(e.getMessage());
        }
        logger.info("Initialized " + this.getMyName());
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.webService.execute(req, res);
    }

    public void destroy() {
        super.destroy();
        if (this.standalone) {
            logger.info("Do not terminate the application server while destroying all scoped beans");
            this.webService.stop();
        }
        logger.info("Destroyed " + this.getMyName());
    }

    private String getMyName() {
        return ((Object)((Object)this)).getClass().getSimpleName() + '@' + Integer.toString(((Object)((Object)this)).hashCode(), 16) + " [" + this.getServletName() + "]";
    }
}

