/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.cors;

import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.util.StringUtils;
import com.aspectran.web.support.cors.CorsProcessor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractCorsProcessor
implements CorsProcessor {
    static final String ALL = "*";
    private Set<String> allowedOrigins;
    private Set<String> allowedMethods;
    private String allowedMethodsString;
    private Set<String> allowedHeaders;
    private String allowedHeadersString;
    private Set<String> exposedHeaders;
    private String exposedHeadersString;
    private boolean allowCredentials;
    private int maxAgeSeconds = -1;

    public String[] getAllowedOrigins() {
        if (this.allowedOrigins != null) {
            return this.allowedOrigins.toArray(new String[0]);
        }
        return null;
    }

    public void setAllowedOrigins(String allowedOrigins) {
        String[] origins = StringUtils.splitCommaDelimitedString((String)allowedOrigins);
        this.setAllowedOrigins(origins);
    }

    public void setAllowedOrigins(String[] allowedOrigins) {
        HashSet<String> set = new HashSet<String>();
        if (allowedOrigins != null) {
            Collections.addAll(set, allowedOrigins);
        }
        this.setAllowedOrigins(set);
    }

    public void setAllowedOrigins(Set<String> allowedOrigins) {
        boolean allowAnyOrigin;
        this.allowedOrigins = allowedOrigins != null && !allowedOrigins.isEmpty() ? ((allowAnyOrigin = allowedOrigins.contains(ALL)) ? null : allowedOrigins) : null;
    }

    public String[] getAllowedMethods() {
        if (this.allowedMethods != null) {
            return this.allowedMethods.toArray(new String[0]);
        }
        return null;
    }

    public boolean containsMethod(String method) {
        return this.allowedMethods != null && this.allowedMethods.contains(method);
    }

    public String getAllowedMethodsString() {
        return this.allowedMethodsString;
    }

    public void setAllowedMethods(String allowedMethods) {
        String[] methods = StringUtils.splitCommaDelimitedString((String)allowedMethods);
        this.setAllowedMethods(methods);
    }

    public void setAllowedMethods(String[] allowedMethods) {
        HashSet<String> set = new HashSet<String>();
        if (allowedMethods != null) {
            Collections.addAll(set, allowedMethods);
        }
        this.setAllowedMethods(set);
    }

    public void setAllowedMethods(Set<String> allowedMethods) {
        if (allowedMethods != null && !allowedMethods.isEmpty()) {
            boolean allowAnyMethod = allowedMethods.contains(ALL);
            if (allowAnyMethod) {
                this.allowedMethods = null;
                this.allowedMethodsString = null;
            } else {
                this.allowedMethods = allowedMethods;
                this.allowedMethodsString = StringUtils.joinCommaDelimitedList(allowedMethods);
            }
        } else {
            this.allowedMethods = null;
            this.allowedMethodsString = null;
        }
    }

    public String[] getAllowedHeaders() {
        if (this.allowedHeaders != null) {
            return this.allowedHeaders.toArray(new String[0]);
        }
        return null;
    }

    public String getAllowedHeadersString() {
        return this.allowedHeadersString;
    }

    public void setAllowedHeaders(String allowedHeaders) {
        String[] headers = StringUtils.splitCommaDelimitedString((String)allowedHeaders);
        this.setAllowedHeaders(headers);
    }

    public void setAllowedHeaders(String[] allowedHeaders) {
        HashSet<String> set = new HashSet<String>();
        if (allowedHeaders != null) {
            Collections.addAll(set, allowedHeaders);
        }
        this.setAllowedHeaders(set);
    }

    public void setAllowedHeaders(Set<String> allowedHeaders) {
        if (allowedHeaders != null && !allowedHeaders.isEmpty()) {
            boolean allowAnyHeader = allowedHeaders.contains(ALL);
            if (allowAnyHeader) {
                this.allowedHeaders = null;
                this.allowedHeadersString = null;
            } else {
                this.allowedHeaders = allowedHeaders;
                this.allowedHeadersString = StringUtils.joinCommaDelimitedList(allowedHeaders);
            }
        } else {
            this.allowedHeaders = null;
            this.allowedHeadersString = null;
        }
    }

    public String[] getExposedHeaders() {
        if (this.exposedHeaders != null) {
            return this.exposedHeaders.toArray(new String[0]);
        }
        return null;
    }

    public String getExposedHeadersString() {
        return this.exposedHeadersString;
    }

    public void setExposedHeaders(String exposedHeaders) {
        String[] headers = StringUtils.splitCommaDelimitedString((String)exposedHeaders);
        this.setExposedHeaders(headers);
    }

    public void setExposedHeaders(String[] exposedHeaders) {
        HashSet<String> set = new HashSet<String>();
        if (exposedHeaders != null) {
            Collections.addAll(set, exposedHeaders);
        }
        this.setExposedHeaders(set);
    }

    public void setExposedHeaders(Set<String> exposedHeaders) {
        if (exposedHeaders != null && !exposedHeaders.isEmpty()) {
            boolean allowAnyHeader = exposedHeaders.contains(ALL);
            if (allowAnyHeader) {
                this.exposedHeaders = null;
                this.exposedHeadersString = null;
            } else {
                this.exposedHeaders = exposedHeaders;
                this.exposedHeadersString = StringUtils.joinCommaDelimitedList(exposedHeaders);
            }
        } else {
            this.exposedHeaders = null;
            this.exposedHeadersString = null;
        }
    }

    public boolean isAllowCredentials() {
        return this.allowCredentials;
    }

    public void setAllowCredentials(boolean allowCredentials) {
        this.allowCredentials = allowCredentials;
    }

    public int getMaxAgeSeconds() {
        return this.maxAgeSeconds;
    }

    public void setMaxAgeSeconds(int maxAgeSeconds) {
        this.maxAgeSeconds = maxAgeSeconds;
    }

    protected boolean hasAllowedOrigins() {
        return this.allowedOrigins != null;
    }

    protected boolean hasAllowedMethods() {
        return this.allowedMethods != null;
    }

    protected boolean hasAllowedHeaders() {
        return this.allowedHeaders != null;
    }

    protected boolean hasExposedHeaders() {
        return this.exposedHeaders != null;
    }

    protected boolean isAllowedOrigin(String origin) {
        return this.allowedOrigins == null || this.allowedOrigins.contains(origin);
    }

    protected boolean isAllowedMethod(String method) {
        if (this.allowedMethods == null) {
            return "GET".equals(method) || "HEAD".equals(method);
        }
        return this.allowedMethods.contains(method);
    }

    protected boolean isAllowedHeader(String header) {
        return this.allowedHeaders == null || this.allowedHeaders.contains(header);
    }

    protected boolean isCorsRequest(HttpServletRequest request) {
        return request.getHeader("Origin") != null;
    }

    protected boolean isPreFlightRequest(HttpServletRequest request) {
        return this.isCorsRequest(request) && MethodType.OPTIONS.name().equals(request.getMethod()) && request.getHeader("Access-Control-Request-Method") != null;
    }
}

