/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.etag;

import com.aspectran.core.activity.Translet;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.ResponseTemplate;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.lang.NonNull;
import com.aspectran.core.util.DigestUtils;
import com.aspectran.core.util.StringUtils;
import com.aspectran.web.support.etag.ETagTokenFactory;
import com.aspectran.web.support.http.HttpStatus;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletResponse;

public class ETagInterceptor {
    private static final String DIRECTIVE_NO_STORE = "no-store";
    private static final Pattern ETAG_HEADER_VALUE_PATTERN = Pattern.compile("\\*|\\s*((W/)?(\"[^\"]*\"))\\s*,?");
    private final ETagTokenFactory tokenFactory;
    private boolean writeWeakETag = false;

    public ETagInterceptor(@NonNull ETagTokenFactory tokenFactory) {
        this.tokenFactory = tokenFactory;
    }

    public void setWriteWeakETag(boolean writeWeakETag) {
        this.writeWeakETag = writeWeakETag;
    }

    public boolean isWriteWeakETag() {
        return this.writeWeakETag;
    }

    public void intercept(Translet translet) {
        HttpServletResponse response = (HttpServletResponse)translet.getResponseAdapter().getAdaptee();
        String cacheControl = response.getHeader("Cache-Control");
        if (cacheControl == null || !cacheControl.contains(DIRECTIVE_NO_STORE)) {
            boolean notModified;
            String token = response.getHeader("ETag");
            if (!StringUtils.hasText((String)token)) {
                token = this.generateETagToken(translet, this.writeWeakETag);
                if (token == null) {
                    return;
                }
                response.setHeader("ETag", token);
            }
            if (notModified = this.validateIfNoneMatch(translet.getRequestAdapter(), token)) {
                ResponseTemplate responseTemplate = new ResponseTemplate(translet.getResponseAdapter());
                responseTemplate.setStatus(HttpStatus.NOT_MODIFIED.value());
                translet.response((Response)responseTemplate);
            }
        }
    }

    protected String generateETagToken(Translet translet, boolean isWeak) {
        byte[] token = this.tokenFactory.getToken(translet);
        if (token == null || token.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder(37);
        if (isWeak) {
            builder.append("W/");
        }
        builder.append("\"0");
        builder.append(DigestUtils.md5DigestAsHex((byte[])token));
        builder.append('\"');
        return builder.toString();
    }

    private boolean validateIfNoneMatch(RequestAdapter requestAdapter, String token) {
        List ifNoneMatch = requestAdapter.getHeaderValues("If-None-Match");
        if (ifNoneMatch == null || ifNoneMatch.isEmpty()) {
            return false;
        }
        if ((token = this.padETagTokenIfNecessary(token)).startsWith("W/")) {
            token = token.substring(2);
        }
        for (String tags : ifNoneMatch) {
            Matcher tokenMatcher = ETAG_HEADER_VALUE_PATTERN.matcher(tags);
            while (tokenMatcher.find()) {
                if (!StringUtils.hasLength((String)tokenMatcher.group()) || !token.equals(tokenMatcher.group(3))) continue;
                return true;
            }
        }
        return false;
    }

    private String padETagTokenIfNecessary(String token) {
        if ((token.startsWith("\"") || token.startsWith("W/\"")) && token.endsWith("\"")) {
            return token;
        }
        return "\"" + token + "\"";
    }
}

