/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.http;

import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.cache.Cache;
import com.aspectran.core.util.cache.ConcurrentLruCache;
import com.aspectran.web.support.http.InvalidMediaTypeException;
import com.aspectran.web.support.http.MediaType;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public abstract class MediaTypeUtils {
    private static final Cache<String, MediaType> cachedMimeTypes = new ConcurrentLruCache(64, MediaTypeUtils::parseMediaTypeInternal);

    protected static MediaType parseMediaType(String mediaType) {
        if (!StringUtils.hasLength((String)mediaType)) {
            throw new InvalidMediaTypeException(mediaType, "'mediaType' must not be empty");
        }
        if (mediaType.startsWith("multipart")) {
            return MediaTypeUtils.parseMediaTypeInternal(mediaType);
        }
        return (MediaType)cachedMimeTypes.get((Object)mediaType);
    }

    private static MediaType parseMediaTypeInternal(String mediaType) {
        int nextIndex;
        int subIndex;
        int index = mediaType.indexOf(59);
        String fullType = (index >= 0 ? mediaType.substring(0, index) : mediaType).trim();
        if (fullType.isEmpty()) {
            throw new InvalidMediaTypeException(mediaType, "'mediaType' must not be empty");
        }
        if ("*".equals(fullType)) {
            fullType = "*/*";
        }
        if ((subIndex = fullType.indexOf(47)) == -1) {
            throw new InvalidMediaTypeException(mediaType, "does not contain '/'");
        }
        if (subIndex == fullType.length() - 1) {
            throw new InvalidMediaTypeException(mediaType, "does not contain subtype after '/'");
        }
        String type = fullType.substring(0, subIndex);
        String subtype = fullType.substring(subIndex + 1);
        if ("*".equals(type) && !"*".equals(subtype)) {
            throw new InvalidMediaTypeException(mediaType, "wildcard type is legal only in '*/*' (all media types)");
        }
        LinkedHashMap<String, String> parameters = null;
        do {
            int eqIndex;
            String parameter;
            boolean quoted = false;
            for (nextIndex = index + 1; nextIndex < mediaType.length(); ++nextIndex) {
                char ch = mediaType.charAt(nextIndex);
                if (ch == ';') {
                    if (quoted) continue;
                    break;
                }
                if (ch != '\"') continue;
                quoted = !quoted;
            }
            if ((parameter = mediaType.substring(index + 1, nextIndex).trim()).length() <= 0) continue;
            if (parameters == null) {
                parameters = new LinkedHashMap<String, String>(4);
            }
            if ((eqIndex = parameter.indexOf(61)) < 0) continue;
            String attribute = parameter.substring(0, eqIndex).trim();
            String value = parameter.substring(eqIndex + 1).trim();
            parameters.put(attribute, value);
        } while ((index = nextIndex) < mediaType.length());
        try {
            return new MediaType(type, subtype, parameters);
        }
        catch (UnsupportedCharsetException ex) {
            throw new InvalidMediaTypeException(mediaType, "unsupported charset '" + ex.getCharsetName() + "'");
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidMediaTypeException(mediaType, ex.getMessage());
        }
    }

    public static List<String> tokenize(String mediaTypes) {
        if (!StringUtils.hasLength((String)mediaTypes)) {
            return Collections.emptyList();
        }
        ArrayList<String> tokens = new ArrayList<String>();
        boolean inQuotes = false;
        int startIndex = 0;
        block5: for (int i = 0; i < mediaTypes.length(); ++i) {
            switch (mediaTypes.charAt(i)) {
                case '\"': {
                    inQuotes = !inQuotes;
                    continue block5;
                }
                case ',': {
                    if (inQuotes) continue block5;
                    tokens.add(mediaTypes.substring(startIndex, i).trim());
                    startIndex = i + 1;
                    continue block5;
                }
                case '\\': {
                    ++i;
                }
            }
        }
        tokens.add(mediaTypes.substring(startIndex).trim());
        return tokens;
    }

    public static String toString(Collection<MediaType> mediaTypes) {
        StringBuilder builder = new StringBuilder();
        Iterator<MediaType> iterator = mediaTypes.iterator();
        while (iterator.hasNext()) {
            MediaType MediaType2 = iterator.next();
            MediaType2.appendTo(builder);
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }
}

