/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.multipart.commons;

import com.aspectran.core.activity.request.FileParameter;
import com.aspectran.core.util.FilenameUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;

public class CommonsMultipartFileParameter
extends FileParameter {
    private FileItem fileItem;
    private long fileSize;

    public CommonsMultipartFileParameter(FileItem fileItem) {
        this.fileItem = fileItem;
        this.fileSize = fileItem.getSize();
    }

    public File getFile() {
        if (this.fileItem instanceof DiskFileItem) {
            return ((DiskFileItem)this.fileItem).getStoreLocation();
        }
        return null;
    }

    public String getContentType() {
        return this.fileItem.getContentType();
    }

    public String getFileName() {
        return this.getCanonicalName(this.fileItem.getName());
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public InputStream getInputStream() throws IOException {
        InputStream inputStream = this.fileItem.getInputStream();
        return inputStream != null ? inputStream : new ByteArrayInputStream(new byte[0]);
    }

    public byte[] getBytes() {
        byte[] bytes = this.fileItem.get();
        return bytes != null ? bytes : new byte[]{};
    }

    public File saveAs(File destFile, boolean overwrite) throws IOException {
        if (destFile == null) {
            throw new IllegalArgumentException("destFile can not be null");
        }
        this.validateFile();
        try {
            destFile = this.determineDestinationFile(destFile, overwrite);
            this.fileItem.write(destFile);
        }
        catch (FileUploadException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (Exception e) {
            throw new IOException("Could not save as file " + destFile, e);
        }
        this.setSavedFile(destFile);
        return destFile;
    }

    public File renameTo(File destFile, boolean overwrite) throws IOException {
        File file = this.getFile();
        if (file == null) {
            throw new IllegalStateException("The uploaded temporary file does not exist");
        }
        if (destFile == null) {
            throw new IllegalArgumentException("destFile can not be null");
        }
        this.validateFile();
        return super.renameTo(destFile, overwrite);
    }

    public void delete() {
        this.fileItem.delete();
    }

    public void release() {
        if (this.fileItem != null) {
            this.fileItem = null;
            this.fileSize = 0L;
        }
        this.releaseSavedFile();
    }

    private String getCanonicalName(String filename) {
        return FilenameUtils.getName((String)filename);
    }

    private void validateFile() {
        if (!this.isAvailable()) {
            throw new IllegalStateException("File has been moved - cannot be read again");
        }
    }

    private boolean isAvailable() {
        if (this.fileItem.isInMemory()) {
            return true;
        }
        if (this.fileItem instanceof DiskFileItem) {
            return ((DiskFileItem)this.fileItem).getStoreLocation().exists();
        }
        return this.fileItem.getSize() == this.fileSize;
    }

    public String getStorageDescription() {
        if (this.fileItem.isInMemory()) {
            return "in memory";
        }
        if (this.fileItem instanceof DiskFileItem) {
            return "at [" + ((DiskFileItem)this.fileItem).getStoreLocation().getAbsolutePath() + "]";
        }
        return "on disk";
    }
}

