/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.multipart.commons;

import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.SystemUtils;
import com.aspectran.web.activity.request.MultipartFormDataParser;
import com.aspectran.web.support.multipart.commons.CommonsMultipartFormDataParser;

public class CommonsMultipartFormDataParserFactory {
    private String tempDirectoryPath;
    private long maxRequestSize = -1L;
    private long maxFileSize = -1L;
    private int maxInMemorySize = -1;
    private String allowedFileExtensions;
    private String deniedFileExtensions;

    public String getTempDirectoryPath() {
        return this.tempDirectoryPath;
    }

    public void setTempDirectoryPath(String tempDirectoryPath) {
        this.tempDirectoryPath = tempDirectoryPath;
    }

    public long getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public void setMaxRequestSize(long maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    public void setMaxRequestSize(String maxRequestSize) {
        this.maxRequestSize = StringUtils.convertToMachineFriendlyByteSize((String)maxRequestSize);
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setMaxFileSize(String maxFileSize) {
        this.maxFileSize = StringUtils.convertToMachineFriendlyByteSize((String)maxFileSize);
    }

    public void setMaxInMemorySize(int maxInMemorySize) {
        this.maxInMemorySize = maxInMemorySize;
    }

    public void setMaxInMemorySize(String maxInMemorySize) {
        this.maxInMemorySize = (int)StringUtils.convertToMachineFriendlyByteSize((String)maxInMemorySize);
    }

    public String getAllowedFileExtensions() {
        return this.allowedFileExtensions;
    }

    public void setAllowedFileExtensions(String allowedFileExtensions) {
        this.allowedFileExtensions = allowedFileExtensions;
    }

    public String getDeniedFileExtensions() {
        return this.deniedFileExtensions;
    }

    public void setDeniedFileExtensions(String deniedFileExtensions) {
        this.deniedFileExtensions = deniedFileExtensions;
    }

    public MultipartFormDataParser createMultipartFormDataParser() {
        CommonsMultipartFormDataParser parser = new CommonsMultipartFormDataParser();
        if (this.tempDirectoryPath != null) {
            parser.setTempDirectoryPath(this.tempDirectoryPath);
        } else {
            parser.setTempDirectoryPath(SystemUtils.getJavaIoTmpDir());
        }
        if (this.maxRequestSize > -1L) {
            parser.setMaxRequestSize(this.maxRequestSize);
        }
        if (this.maxFileSize > -1L) {
            parser.setMaxFileSize(this.maxFileSize);
        }
        if (this.maxInMemorySize > -1) {
            parser.setMaxInMemorySize(this.maxInMemorySize);
        }
        parser.setAllowedFileExtensions(this.allowedFileExtensions);
        parser.setDeniedFileExtensions(this.deniedFileExtensions);
        return parser;
    }
}

