/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.multipart.inmemory;

import com.aspectran.core.activity.request.SizeLimitExceededException;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.util.FilenameUtils;
import com.aspectran.core.util.LinkedMultiValueMap;
import com.aspectran.core.util.MultiValueMap;
import com.aspectran.core.util.StringUtils;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import com.aspectran.web.activity.request.MultipartFormDataParser;
import com.aspectran.web.activity.request.MultipartRequestParseException;
import com.aspectran.web.support.multipart.commons.CommonsRequestContext;
import com.aspectran.web.support.multipart.inmemory.InMemoryFileItemFactory;
import com.aspectran.web.support.multipart.inmemory.InMemoryMultipartFileParameter;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class InMemoryMultipartFormDataParser
implements MultipartFormDataParser {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryMultipartFormDataParser.class);
    private long maxRequestSize = -1L;
    private long maxFileSize = -1L;
    private int maxInMemorySize = -1;
    private String allowedFileExtensions;
    private String deniedFileExtensions;

    @Override
    public String getTempDirectoryPath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTempDirectoryPath(String tempDirectoryPath) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMaxRequestSize(long maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    @Override
    public void setMaxFileSize(long maxFileSize) {
        if (maxFileSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("In the In-Memory file uploads,the maximum file size is up to 2147483648 bytes");
        }
        this.maxFileSize = maxFileSize;
        this.maxInMemorySize = (int)maxFileSize;
    }

    @Override
    public void setMaxInMemorySize(int maxInMemorySize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAllowedFileExtensions(String allowedFileExtensions) {
        this.allowedFileExtensions = allowedFileExtensions;
    }

    @Override
    public void setDeniedFileExtensions(String deniedFileExtensions) {
        this.deniedFileExtensions = deniedFileExtensions;
    }

    @Override
    public void parse(RequestAdapter requestAdapter) throws MultipartRequestParseException {
        try {
            Map fileItemListMap;
            InMemoryFileItemFactory factory = new InMemoryFileItemFactory();
            if (this.maxInMemorySize > -1) {
                factory.setSizeThreshold(this.maxInMemorySize);
            }
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            upload.setHeaderEncoding(requestAdapter.getEncoding());
            if (this.maxRequestSize > -1L) {
                upload.setSizeMax(this.maxRequestSize);
            }
            if (this.maxFileSize > -1L) {
                upload.setFileSizeMax(this.maxFileSize);
            }
            try {
                CommonsRequestContext requestContext = new CommonsRequestContext(requestAdapter);
                fileItemListMap = upload.parseParameterMap((RequestContext)requestContext);
            }
            catch (FileUploadBase.SizeLimitExceededException e) {
                throw new SizeLimitExceededException("Maximum request length exceeded; actual: " + e.getActualSize() + "; permitted: " + e.getPermittedSize(), e.getActualSize(), e.getPermittedSize());
            }
            catch (FileUploadBase.FileSizeLimitExceededException e) {
                throw new SizeLimitExceededException("Maximum file length exceeded; actual: " + e.getActualSize() + "; permitted: " + e.getPermittedSize(), e.getActualSize(), e.getPermittedSize());
            }
            this.parseMultipartParameters(fileItemListMap, requestAdapter);
        }
        catch (Exception e) {
            throw new MultipartRequestParseException("Failed to parse multipart request; nested exception is " + e, e);
        }
    }

    private void parseMultipartParameters(Map<String, List<FileItem>> fileItemListMap, RequestAdapter requestAdapter) {
        String encoding = requestAdapter.getEncoding();
        LinkedMultiValueMap parameterMap = new LinkedMultiValueMap();
        LinkedMultiValueMap fileParameterMap = new LinkedMultiValueMap();
        for (Map.Entry<String, List<FileItem>> entry : fileItemListMap.entrySet()) {
            String fieldName = entry.getKey();
            List<FileItem> fileItemList = entry.getValue();
            if (fileItemList == null || fileItemList.isEmpty()) continue;
            for (FileItem fileItem : fileItemList) {
                boolean valid;
                if (fileItem.isFormField()) {
                    String value = this.getString(fileItem, encoding);
                    parameterMap.add((Object)fieldName, (Object)value);
                    continue;
                }
                String fileName = fileItem.getName();
                if (StringUtils.isEmpty((String)fileName) || !(valid = FilenameUtils.isValidFileExtension((String)fileName, (String)this.allowedFileExtensions, (String)this.deniedFileExtensions))) continue;
                InMemoryMultipartFileParameter fileParameter = new InMemoryMultipartFileParameter(fileItem);
                fileParameterMap.add((Object)fieldName, (Object)fileParameter);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Found multipart file [" + fileParameter.getFileName() + "] of size " + fileParameter.getFileSize() + " bytes, stored " + fileParameter.getStorageDescription());
            }
        }
        requestAdapter.putAllParameters((MultiValueMap)parameterMap);
        requestAdapter.putAllFileParameters((MultiValueMap)fileParameterMap);
    }

    private String getString(FileItem fileItem, String encoding) {
        String value;
        if (encoding != null) {
            try {
                value = fileItem.getString(encoding);
            }
            catch (UnsupportedEncodingException ex) {
                logger.warn("Could not decode multipart item '" + fileItem.getFieldName() + "' with encoding '" + encoding + "': using platform default");
                value = fileItem.getString();
            }
        } else {
            value = fileItem.getString();
        }
        return value;
    }
}

