/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.multipart.inmemory;

import com.aspectran.core.util.StringUtils;
import com.aspectran.web.activity.request.MultipartFormDataParser;
import com.aspectran.web.support.multipart.inmemory.InMemoryMultipartFormDataParser;

public class InMemoryMultipartFormDataParserFactory {
    private long maxRequestSize = -1L;
    private long maxFileSize = -1L;
    private String allowedFileExtensions;
    private String deniedFileExtensions;

    public long getMaxRequestSize() {
        return this.maxRequestSize;
    }

    public void setMaxRequestSize(long maxRequestSize) {
        this.maxRequestSize = maxRequestSize;
    }

    public void setMaxRequestSize(String maxRequestSize) {
        this.maxRequestSize = StringUtils.convertToMachineFriendlyByteSize((String)maxRequestSize);
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public void setMaxFileSize(String maxFileSize) {
        this.maxFileSize = StringUtils.convertToMachineFriendlyByteSize((String)maxFileSize);
    }

    public String getAllowedFileExtensions() {
        return this.allowedFileExtensions;
    }

    public void setAllowedFileExtensions(String allowedFileExtensions) {
        this.allowedFileExtensions = allowedFileExtensions;
    }

    public String getDeniedFileExtensions() {
        return this.deniedFileExtensions;
    }

    public void setDeniedFileExtensions(String deniedFileExtensions) {
        this.deniedFileExtensions = deniedFileExtensions;
    }

    public MultipartFormDataParser createMultipartFormDataParser() {
        InMemoryMultipartFormDataParser parser = new InMemoryMultipartFormDataParser();
        if (this.maxRequestSize > -1L) {
            parser.setMaxRequestSize(this.maxRequestSize);
        }
        if (this.maxFileSize > -1L) {
            parser.setMaxFileSize(this.maxFileSize);
        }
        parser.setAllowedFileExtensions(this.allowedFileExtensions);
        parser.setDeniedFileExtensions(this.deniedFileExtensions);
        return parser;
    }
}

