/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.multipart.inmemory;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ThresholdingOutputStream;

public class InMemoryOutputStream
extends ThresholdingOutputStream {
    private final ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private boolean closed;

    public InMemoryOutputStream(long threshold) {
        super((int)threshold);
    }

    protected OutputStream getStream() throws IOException {
        return this.outputStream;
    }

    protected void thresholdReached() {
        throw new UnsupportedOperationException("Not possible in GAE. Will never reach!! Try changing max upload size setting.");
    }

    public boolean isInMemory() {
        return true;
    }

    public byte[] getData() {
        return this.outputStream.toByteArray();
    }

    public void close() throws IOException {
        super.close();
        this.closed = true;
    }

    public void writeTo(OutputStream out) throws IOException {
        if (!this.closed) {
            throw new IOException("Stream not closed");
        }
        this.outputStream.writeTo(out);
    }
}

