/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.tags;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.lang.Nullable;
import com.aspectran.core.util.Assert;
import com.aspectran.core.util.logging.Logger;
import com.aspectran.core.util.logging.LoggerFactory;
import com.aspectran.web.service.WebServiceHolder;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.TryCatchFinally;

public abstract class CurrentActivityAwareTag
extends TagSupport
implements TryCatchFinally {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Nullable
    private Activity currentActivity;

    public final int doStartTag() throws JspException {
        try {
            ActivityContext context = WebServiceHolder.getCurrentActivityContext();
            if (context == null) {
                throw new IllegalStateException("Failed to find WebService");
            }
            this.currentActivity = context.getCurrentActivity();
            return this.doStartTagInternal();
        }
        catch (RuntimeException | JspException ex) {
            this.logger.error(ex.getMessage(), ex);
            throw ex;
        }
        catch (Exception ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            throw new JspTagException(ex.getMessage());
        }
    }

    protected final Activity getCurrentActivity() {
        Assert.state((this.currentActivity != null ? 1 : 0) != 0, (String)"No current activity injected");
        return this.currentActivity;
    }

    protected abstract int doStartTagInternal() throws Exception;

    public void doCatch(Throwable throwable) throws Throwable {
        throw throwable;
    }

    public void doFinally() {
        this.currentActivity = null;
    }
}

