/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.tags;

import com.aspectran.core.lang.Nullable;
import com.aspectran.core.util.Assert;
import com.aspectran.web.support.tags.HtmlEscapingAwareTag;
import com.aspectran.web.support.util.JavaScriptUtils;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;

public class EscapeBodyTag
extends HtmlEscapingAwareTag
implements BodyTag {
    private boolean javaScriptEscape;
    @Nullable
    private BodyContent bodyContent;

    public void setJavaScriptEscape(boolean javaScriptEscape) {
        this.javaScriptEscape = javaScriptEscape;
    }

    @Override
    protected int doStartTagInternal() {
        return 2;
    }

    public void doInitBody() {
    }

    public void setBodyContent(@Nullable BodyContent bodyContent) {
        this.bodyContent = bodyContent;
    }

    public int doAfterBody() throws JspException {
        try {
            String content = this.readBodyContent();
            content = this.htmlEscape(content);
            content = this.javaScriptEscape ? JavaScriptUtils.javaScriptEscape(content) : content;
            this.writeBodyContent(content);
        }
        catch (IOException ex) {
            throw new JspException("Could not write escaped body", (Throwable)ex);
        }
        return 0;
    }

    protected String readBodyContent() {
        Assert.state((this.bodyContent != null ? 1 : 0) != 0, (String)"No BodyContent set");
        return this.bodyContent.getString();
    }

    protected void writeBodyContent(String content) throws IOException {
        Assert.state((this.bodyContent != null ? 1 : 0) != 0, (String)"No BodyContent set");
        this.bodyContent.getEnclosingWriter().print(content);
    }
}

