/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.support.tags;

import com.aspectran.core.context.expr.TokenEvaluation;
import com.aspectran.core.context.expr.TokenEvaluator;
import com.aspectran.core.context.expr.token.Token;
import com.aspectran.core.context.expr.token.TokenParser;
import com.aspectran.core.context.rule.type.TokenType;
import com.aspectran.core.lang.Nullable;
import com.aspectran.core.util.ObjectUtils;
import com.aspectran.web.support.tags.HtmlEscapingAwareTag;
import com.aspectran.web.support.util.JavaScriptUtils;
import com.aspectran.web.support.util.TagUtils;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;

public class TokenTag
extends HtmlEscapingAwareTag {
    protected static final String TOKEN_EVALUATOR_PAGE_ATTRIBUTE = "com.aspectran.web.support.tags.TOKEN_EVALUATOR";
    @Nullable
    private String type;
    @Nullable
    private String expression;
    @Nullable
    private String var;
    private int scope = 1;
    private boolean javaScriptEscape = false;

    public void setType(@Nullable String type) {
        this.type = type;
    }

    public void setExpression(@Nullable String expression) {
        this.expression = expression;
    }

    public void setVar(@Nullable String var) {
        this.var = var;
    }

    public void setScope(String scope) {
        this.scope = TagUtils.getScope(scope);
    }

    public void setJavaScriptEscape(boolean javaScriptEscape) {
        this.javaScriptEscape = javaScriptEscape;
    }

    @Override
    public int doStartTagInternal() throws JspException {
        return 1;
    }

    public int doEndTag() throws JspException {
        TokenEvaluator tokenEvaluator = (TokenEvaluator)this.pageContext.getAttribute(TOKEN_EVALUATOR_PAGE_ATTRIBUTE);
        if (tokenEvaluator == null) {
            tokenEvaluator = new TokenEvaluation(this.getCurrentActivity());
            this.pageContext.setAttribute(TOKEN_EVALUATOR_PAGE_ATTRIBUTE, (Object)tokenEvaluator);
        }
        try {
            if (this.type == null) {
                throw new IllegalArgumentException("No token type set");
            }
            TokenType tokenType = TokenType.resolve((String)this.type);
            if (tokenType == null) {
                throw new IllegalArgumentException("Unknown token type: " + this.type);
            }
            Token[] tokens = TokenParser.parse((String)Token.format((TokenType)tokenType, (String)this.expression));
            if (this.var != null) {
                Object result = tokenEvaluator.evaluate(tokens);
                this.pageContext.setAttribute(this.var, result, this.scope);
            } else {
                try {
                    Object result = tokenEvaluator.evaluate(tokens);
                    String str = ObjectUtils.getDisplayString((Object)result);
                    str = this.htmlEscape(str);
                    if (this.javaScriptEscape) {
                        str = JavaScriptUtils.javaScriptEscape(str);
                    }
                    this.pageContext.getOut().print(str);
                }
                catch (IOException ex) {
                    throw new JspException((Throwable)ex);
                }
            }
            return 6;
        }
        catch (Exception ex) {
            throw new JspTagException(ex.getMessage(), (Throwable)ex);
        }
    }
}

